/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Config;
import com.wego168.base.persistence.ConfigMapper;
import com.wego168.base.service.ConfigService;
import com.wego168.service.CrudService;
import com.wego168.util.DateUtil;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.GuidGenerator;
import com.wego168.web.util.ParamUtils;
import com.wego168.web.util.ServletContextHolder;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/config"})
public class ConfigController
extends CrudController<Config> {
    @Autowired
    private ConfigService configService;
    @Autowired
    private ConfigMapper configMapper;

    public CrudService<Config> getService() {
        return this.configService;
    }

    @ApiOperation(value="\u6839\u636ekey\u83b7\u53d6value")
    @GetMapping(value={"/{key}"})
    public RestResponse getByKey(@PathVariable String key) {
        Config config = this.configService.getByKey(key);
        return RestResponse.success((Object)((Object)config));
    }

    @GetMapping(value={"/queryByParentId"})
    public RestResponse queryByParentId() {
        String parentId = ParamUtils.getString((ServletRequest)ServletContextHolder.getRequest(), (String)"parentId");
        List list = this.configService.selectList(JpaCriteria.builder().eq("parentId", (Object)parentId).orderBy("seqNum asc"));
        return RestResponse.success((Object)list);
    }

    @ApiOperation(value="\u8ba2\u5355\u672a\u652f\u4ed8\u591a\u4e45\u53d6\u6d88\u8ba2\u5355")
    @GetMapping(value={"/shopOrderCancelTime"})
    public RestResponse getShopOrderCancelTime() {
        Config config = this.configService.getByKey("SHOPPING_ORDER_CANCEL_TIME");
        Shift.throwsIfNull((Object)((Object)config), (String)"\u914d\u7f6e\u4e3a\u7a7a");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        try {
            String value = config.getValue();
            Date date = simpleDateFormat.parse(value);
            config.setValue(String.valueOf(DateUtil.HourTransformMinute((Date)date)));
        }
        catch (ParseException e) {
            return RestResponse.error((String)"\u6570\u636e\u51fa\u9519\uff0c\u683c\u5f0f\u8f6c\u5316\u5931\u8d25");
        }
        return RestResponse.success((Object)((Object)config));
    }

    @GetMapping(value={"/listByParentIdIfAbsentToInit"})
    public RestResponse listByParentIdIfAbsentToInit(String parentId) {
        List list = this.configService.selectList(JpaCriteria.builder().eq("parentId", (Object)parentId).orderBy("seqNum asc"));
        if ((list == null || list.size() == 0) && (list = this.configMapper.selectList(JpaCriteria.builder().eq("parentId", (Object)parentId).eq("appId", (Object)"templatexsj000000000000000000000").orderBy("seqNum asc"))) != null && list.size() > 0) {
            LinkedList<Config> results = new LinkedList<Config>();
            for (Config cfgDb : list) {
                Config config = new Config();
                BeanUtils.copyProperties((Object)((Object)cfgDb), (Object)((Object)config));
                config.setId(GuidGenerator.generate());
                config.setAppId(this.getAppId());
                results.add(config);
            }
            this.configService.insertBatch(results);
        }
        return RestResponse.success((Object)list);
    }
}

