/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Content;
import com.wego168.base.domain.PersonIp;
import com.wego168.base.enums.PersonIpObjectTypeEnum;
import com.wego168.base.model.response.PersonIpWebGetResponse;
import com.wego168.base.model.response.PersonIpWebListResponse;
import com.wego168.base.service.ContentService;
import com.wego168.base.service.PersonIpObjectService;
import com.wego168.base.service.PersonIpService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="webPersonIpController")
@RequestMapping
public class PersonIpController
extends SimpleController {
    @Autowired
    private ContentService contentService;
    @Autowired
    private PersonIpService personIpService;
    @Autowired
    private PersonIpObjectService personIpObjectService;

    @GetMapping(value={"/api/v1/person-ip/page"})
    public RestResponse selectPage(String assembleObjectQuantityType, HttpServletRequest request) {
        try {
            Page page = this.buildPage(request);
            String appId = this.getAppId();
            List<PersonIpWebListResponse> list = this.personIpService.selectPageForWeb(appId, page);
            if (StringUtil.isNotBlank((String)assembleObjectQuantityType) && list != null && list.size() > 0) {
                Checker.checkInRange((Object)((Object)PersonIpObjectTypeEnum.get(assembleObjectQuantityType)), (Object[])PersonIpObjectTypeEnum.values(), (String)"\u9519\u8bef\u7684\u4eba\u7269\u5173\u8054\u5bf9\u8c61\u7c7b\u578b");
                this.personIpObjectService.assembleObjectQuantity(list, assembleObjectQuantityType);
            }
            page.setList(list);
            return RestResponse.success((Object)page);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/person-ip/get"})
    public RestResponse selectPage(String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
            PersonIp personIpDb = (PersonIp)((Object)this.personIpService.selectById(id));
            Checker.checkCondition((personIpDb == null ? 1 : 0) != 0, (String)"\u8be5\u4eba\u7269ip\u4e0d\u5b58\u5728");
            Content contentDb = (Content)this.contentService.selectById(personIpDb.getContentId());
            return RestResponse.success((Object)new PersonIpWebGetResponse(personIpDb, contentDb));
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

