/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Praisable;
import com.wego168.base.domain.Praise;
import com.wego168.base.service.PraiseService;
import com.wego168.base.service.SourceDataService;
import com.wego168.base.service.callback.Callback;
import com.wego168.util.Checker;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class PraiseControllerSupport
extends SimpleController {
    public RestResponse insertPraise(String sourceId, Integer sourceType, String memberId) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        Praisable source = this.sourceIsValid(sourceId, sourceType);
        if (source == null) {
            return RestResponse.error((String)"\u9519\u8bef\u7684\u6765\u6e90");
        }
        List<Praise> list = this.getPraiseService().selectBySourceId(sourceId, memberId);
        if (list != null && list.size() > 0) {
            return RestResponse.error((String)"\u60a8\u5df2\u7ecf\u8d5e\u8fc7\u4e86~");
        }
        Praise praise = this.getPraiseService().create(memberId, sourceId, sourceType);
        this.getPraiseService().addPraise(praise, source, new Callback<Praisable>(){

            @Override
            public Praisable execute(Praisable praisable) {
                praisable.setPraiseQuantity(praisable.getPraiseQuantity() + 1);
                PraiseControllerSupport.this.getPraiseService().updatePraiseQuantity(praisable);
                return praisable;
            }
        });
        return RestResponse.success((Object)((Object)praise));
    }

    public RestResponse insertPraiseByOpenId(String sourceId, Integer sourceType, String openId) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        Praisable source = this.sourceIsValid(sourceId, sourceType);
        if (source == null) {
            return RestResponse.error((String)"\u9519\u8bef\u7684\u6765\u6e90");
        }
        List<Praise> list = this.getPraiseService().selectBySourceIdAndOpenId(sourceId, openId);
        if (list != null && list.size() > 0) {
            return RestResponse.error((String)"\u60a8\u5df2\u7ecf\u8d5e\u8fc7\u4e86~");
        }
        Praise praise = this.getPraiseService().createByOpenId(openId, sourceId, sourceType);
        this.getPraiseService().addPraise(praise, source, new Callback<Praisable>(){

            @Override
            public Praisable execute(Praisable praisable) {
                praisable.setPraiseQuantity(praisable.getPraiseQuantity() + 1);
                PraiseControllerSupport.this.getPraiseService().updatePraiseQuantity(praisable);
                return praisable;
            }
        });
        return RestResponse.success((Object)((Object)praise));
    }

    public RestResponse selectPage(String sourceId, HttpServletRequest request) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        PraiseService praiseService = this.getPraiseService();
        Page page = this.buildPage(request);
        List<Praise> list = praiseService.selectPage(sourceId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    public RestResponse deletePraise(String sourceId, Integer sourceType, String memberId) {
        Praisable source = this.sourceIsValid(sourceId, sourceType);
        if (source == null) {
            return RestResponse.error((String)"\u9519\u8bef\u7684\u6765\u6e90");
        }
        List<Praise> list = this.getPraiseService().selectBySourceId(sourceId, memberId);
        if (list == null || list.size() == 0) {
            return RestResponse.error((String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        this.getPraiseService().deletePraise(sourceId, memberId, source, new Callback<Praisable>(){

            @Override
            public Praisable execute(Praisable praisable) {
                praisable.setPraiseQuantity(praisable.getPraiseQuantity() - 1);
                PraiseControllerSupport.this.getPraiseService().updatePraiseQuantity(praisable);
                return praisable;
            }
        });
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public RestResponse deletePraiseByOpenId(String sourceId, Integer sourceType, String openId) {
        Praisable source = this.sourceIsValid(sourceId, sourceType);
        if (source == null) {
            return RestResponse.error((String)"\u9519\u8bef\u7684\u6765\u6e90");
        }
        List<Praise> list = this.getPraiseService().selectBySourceIdAndOpenId(sourceId, openId);
        if (list == null || list.size() == 0) {
            return RestResponse.error((String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        this.getPraiseService().deletePraiseByOpenId(sourceId, openId, source, new Callback<Praisable>(){

            @Override
            public Praisable execute(Praisable praisable) {
                praisable.setPraiseQuantity(praisable.getPraiseQuantity() - 1);
                PraiseControllerSupport.this.getPraiseService().updatePraiseQuantity(praisable);
                return praisable;
            }
        });
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public RestResponse isPraised(String sourceId, String memberId) {
        List<Praise> list = this.getPraiseService().selectBySourceId(sourceId, memberId);
        return RestResponse.success((Object)(list != null && list.size() > 0 ? 1 : 0));
    }

    public RestResponse isPraisedByOpenId(String sourceId, String openId) {
        List<Praise> list = this.getPraiseService().selectBySourceIdAndOpenId(sourceId, openId);
        return RestResponse.success((Object)(list != null && list.size() > 0 ? 1 : 0));
    }

    protected abstract Praisable sourceIsValid(String var1, int var2);

    protected abstract PraiseService getPraiseService();

    protected abstract SourceDataService getSourceDataService();
}

