/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.wego168.redis.RedisLockUtil;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.web.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RedisController {
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private RedisLockUtil redisLockUtil;

    @GetMapping(value={"/redis/get"})
    public RestResponse get(String key, String type) {
        try {
            Class<?> clazz = Class.forName(type);
            return RestResponse.success((Object)this.simpleRedisTemplate.get(key, clazz));
        }
        catch (ClassNotFoundException e) {
            return RestResponse.error((String)"\u8be5\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
    }

    @GetMapping(value={"/redis/getString"})
    public RestResponse getString(String key) {
        return RestResponse.success((String)this.simpleRedisTemplate.getString(key));
    }

    @PostMapping(value={"/redis/delete"})
    public RestResponse delete(String key) {
        this.simpleRedisTemplate.delete(new String[]{key});
        return RestResponse.success((String)"");
    }

    @PostMapping(value={"/redis/deleteValidateCodeCache"})
    public RestResponse deleteValidateCodeCache(String mobile, String ip) {
        this.redisLockUtil.clearLock(mobile, ip);
        return RestResponse.success((String)"");
    }
}

