/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Sharable;
import com.wego168.base.domain.Share;
import com.wego168.base.service.ShareService;
import com.wego168.base.service.SourceDataService;
import com.wego168.base.service.callback.Callback;
import com.wego168.util.Checker;
import com.wego168.util.Shift;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShareControllerSupport
extends SimpleController {
    private static final Logger log = LoggerFactory.getLogger(ShareControllerSupport.class);

    public RestResponse insertShare(String sourceId, Integer sourceType, String memberId, String url, String appId) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        Checker.checkBlank((String)url, (String)"\u8f6c\u53d1\u94fe\u63a5");
        Sharable source = this.sourceIsValid(sourceId, sourceType);
        Shift.throwsIfNull((Object)source, (String)"\u9519\u8bef\u7684\u6765\u6e90");
        String title = source.getTitle();
        Share share = this.getShareService().create(memberId, sourceId, sourceType, title, url, appId);
        this.getShareService().addShare(share, source, new Callback<Sharable>(){

            @Override
            public Sharable execute(Sharable sharable) {
                sharable.setShareQuantity(sharable.getShareQuantity() + 1);
                ShareControllerSupport.this.getShareService().updateShareQuantity(sharable);
                return sharable;
            }
        });
        return RestResponse.success((Object)((Object)share));
    }

    protected RestResponse insertShareByOpenId(String sourceId, Integer sourceType, String openId, String url, String appId) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        Checker.checkBlank((String)url, (String)"\u8f6c\u53d1\u94fe\u63a5");
        Sharable source = this.sourceIsValid(sourceId, sourceType);
        Shift.throwsIfNull((Object)source, (String)"\u9519\u8bef\u7684\u6765\u6e90");
        String title = source.getTitle();
        Share share = this.getShareService().createByOpenId(openId, sourceId, sourceType, title, url, appId);
        this.getShareService().addShare(share, source, new Callback<Sharable>(){

            @Override
            public Sharable execute(Sharable sharable) {
                sharable.setShareQuantity(sharable.getShareQuantity() + 1);
                ShareControllerSupport.this.getShareService().updateShareQuantity(sharable);
                return sharable;
            }
        });
        return RestResponse.success((Object)((Object)share));
    }

    public RestResponse selectPage(String sourceId, HttpServletRequest request) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        ShareService shareService = this.getShareService();
        Page page = this.buildPage(request);
        List<Share> list = shareService.selectPage(sourceId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    protected abstract Sharable sourceIsValid(String var1, int var2);

    protected abstract ShareService getShareService();

    protected abstract SourceDataService getSourceDataService();
}

