/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.simple.mybatis.Page;
import com.wego168.base.domain.SingleContent;
import com.wego168.base.domain.VisitableBean;
import com.wego168.base.enums.VisitSourceTypeEnum;
import com.wego168.base.service.SingleContentService;
import com.wego168.service.CrudService;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SingleContentController
extends CrudController<SingleContent> {
    @Autowired
    private SingleContentService singleContentService;

    public CrudService<SingleContent> getService() {
        return this.singleContentService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u5355\u56fe\u6587")
    @GetMapping(value={"/api/v1/singleContent/get"})
    public RestResponse get(String id, HttpServletRequest request) {
        SingleContent singleContent = this.singleContentService.get(id);
        int sourceType = VisitSourceTypeEnum.SINGLE_CONTENT.value();
        String memberId = "0";
        request.setAttribute("VISITABLE_TARGET", (Object)new VisitableBean(singleContent, sourceType, memberId));
        return RestResponse.success((Object)singleContent);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5355\u56fe\u6587")
    @GetMapping(value={"/api/v1/singleContent/page"})
    public RestResponse page(String title, String categoryId, Integer status, String orderBy, HttpServletRequest request) {
        Page page = this.buildPage(request);
        if (StringUtil.isNotBlank((String)title)) {
            page.put((Object)"title", (Object)("%" + title + "%"));
        }
        page.put((Object)"categoryId", (Object)categoryId);
        page.put((Object)"status", (Object)status);
        List<SingleContent> lists = this.singleContentService.selectSingleContentPage(orderBy, page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/singleContent/ids"})
    public RestResponse ids(String idStr, String orderBy, HttpServletRequest request) {
        if (StringUtil.isBlank((String)idStr)) {
            return RestResponse.success(null);
        }
        String[] ids = idStr.split("_");
        if (ids == null || ids.length == 0) {
            return RestResponse.success(null);
        }
        Page page = this.buildPage(request);
        page.put((Object)"ids", (Object)ids);
        List<SingleContent> lists = this.singleContentService.selectSingleContentPage(orderBy, page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }
}

