/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.model;

import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import com.wego168.util.StringUtil;

public class Character {
    private char character;
    private String[] pinyinArray;

    public Character(char character) {
        this.character = character;
        if (StringUtil.isChineseCharacter((char)character)) {
            this.pinyinArray = PinyinHelper.convertToPinyinArray((char)character, (PinyinFormat)PinyinFormat.WITHOUT_TONE);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Character)) {
            return false;
        }
        Character that = (Character)obj;
        return that.getCharacter() == this.character;
    }

    public int hashCode() {
        return new java.lang.Character(this.character).hashCode();
    }

    public boolean characterOrPinyinEquals(Object obj) {
        String[] thatPinyinArray;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Character)) {
            return false;
        }
        Character that = (Character)obj;
        char thatChar = that.getCharacter();
        if (thatChar == this.character) {
            return true;
        }
        if (!StringUtil.isChineseCharacter((char)thatChar) || this.pinyinArray == null) {
            return false;
        }
        for (String thatPinyin : thatPinyinArray = PinyinHelper.convertToPinyinArray((char)thatChar, (PinyinFormat)PinyinFormat.WITHOUT_TONE)) {
            for (String thisPinyin : this.pinyinArray) {
                if (!StringUtil.equals((String)thatPinyin, (String)thisPinyin)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.character);
    }

    public static void main(String[] args) {
        String[] convertToPinyinArray;
        for (String string : convertToPinyinArray = PinyinHelper.convertToPinyinArray((char)'\u957f', (PinyinFormat)PinyinFormat.WITHOUT_TONE)) {
            System.out.println(string);
        }
    }

    public char getCharacter() {
        return this.character;
    }

    public String[] getPinyinArray() {
        return this.pinyinArray;
    }

    public void setCharacter(char character) {
        this.character = character;
    }

    public void setPinyinArray(String[] pinyinArray) {
        this.pinyinArray = pinyinArray;
    }
}

