/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.scheduler;

import com.wego168.base.domain.CronJob;
import com.wego168.base.service.CronJobService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

public class DynamicSchedule
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DynamicSchedule.class);
    @Autowired
    private CronJobService cronJobService;
    @Autowired
    private ApplicationContext context;
    private static final Map<String, Object> INSTANCE_MAP = new HashMap<String, Object>();
    private static final Map<String, Object> METHOD_MAP = new HashMap<String, Object>();

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        this.initJob();
        List jobList = null;
        if (Objects.nonNull(jobList)) {
            for (CronJob cronJob : jobList) {
                log.info("\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1\uff1a{}\uff0ccron\uff1a{}", (Object)cronJob.getMethod(), (Object)cronJob.getCron());
                String className = cronJob.getMethod().substring(0, cronJob.getMethod().lastIndexOf("."));
                String methodName = cronJob.getMethod().substring(cronJob.getMethod().lastIndexOf(".") + 1, cronJob.getMethod().length());
                try {
                    Class<?> clazz = Class.forName(className);
                    INSTANCE_MAP.put(cronJob.getMethod(), clazz.newInstance());
                    METHOD_MAP.put(cronJob.getMethod(), clazz.getDeclaredMethod(methodName, new Class[0]));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException e) {
                    e.printStackTrace();
                }
                Object method = METHOD_MAP.get(cronJob.getMethod());
                Runnable task = () -> {
                    CronJob job = (CronJob)((Object)((Object)this.cronJobService.selectById(cronJob.getId())));
                    if (!job.getIsDeleted().booleanValue() && job.getStatus() == CronJob.STOP) {
                        int success = 0;
                        try {
                            success = this.cronJobService.updateToRunning(job);
                            if (success == 1) {
                                cronJob.setCron(job.getCron());
                                ((Method)method).invoke(INSTANCE_MAP.get(cronJob.getMethod()), new Object[0]);
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            log.error("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0cID\uff1a{}\uff0c\u76ee\u6807\u65b9\u6cd5\uff1a{}\uff0c\u8868\u8fbe\u5f0f\uff1a{}", new Object[]{cronJob.getId(), cronJob.getMethod(), cronJob.getCron(), e});
                        }
                        finally {
                            if (success == 1) {
                                job.setLockVersion(job.getLockVersion() + 1L);
                                this.cronJobService.updateToStop(job);
                            }
                        }
                    }
                };
                Trigger trigger = triggerContext -> {
                    CronTrigger cronTrigger = new CronTrigger(cronJob.getCron());
                    return cronTrigger.nextExecutionTime(triggerContext);
                };
                scheduledTaskRegistrar.addTriggerTask(task, trigger);
            }
        }
    }

    private void initJob() {
        LinkedList<CronJob> cronJobList = new LinkedList<CronJob>();
        Map beans = this.context.getBeansWithAnnotation(Component.class);
        for (Object bean : beans.values()) {
            Method[] methods = bean.getClass().getDeclaredMethods();
            for (Method declaredMethod : methods) {
                Scheduled scheduled = (Scheduled)AnnotationUtils.findAnnotation((Method)declaredMethod, Scheduled.class);
                if (!Objects.nonNull(scheduled)) continue;
                String beanTypeName = bean.getClass().getTypeName();
                String fullMethod = beanTypeName.substring(0, beanTypeName.indexOf("$$")).concat(".").concat(declaredMethod.getName());
                String cron = scheduled.cron();
                cronJobList.add(CronJob.of(fullMethod, cron));
            }
        }
        Map<Object, Object> dbJobMap = new HashMap();
        List<CronJob> jobList = this.cronJobService.list();
        if (jobList != null && jobList.size() > 0) {
            dbJobMap = jobList.stream().collect(Collectors.toMap(CronJob::getMethod, e -> e));
        }
        if (cronJobList != null && cronJobList.size() > 0) {
            LinkedList<CronJob> resultList = new LinkedList<CronJob>();
            for (CronJob cron : cronJobList) {
                String fullMethod = cron.getMethod();
                if (!dbJobMap.containsKey(fullMethod)) {
                    resultList.add(cron);
                    continue;
                }
                dbJobMap.remove(fullMethod);
            }
            this.cronJobService.insertBatch(resultList);
        }
        if (dbJobMap.size() > 0) {
            for (String fullMethod : dbJobMap.keySet()) {
                this.cronJobService.deleteById(((CronJob)((Object)dbJobMap.get(fullMethod))).getId());
            }
        }
    }
}

