/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Agreement;
import com.wego168.base.domain.Content;
import com.wego168.base.persistence.AgreementMapper;
import com.wego168.base.persistence.ContentMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AgreementService
extends CrudService<Agreement> {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private ContentMapper contentMapper;

    public CrudMapper<Agreement> getMapper() {
        return this.agreementMapper;
    }

    public Agreement create(String title, String content, String code, int sortNumber, String appId) {
        Agreement agreement = new Agreement();
        BaseDomainUtil.initBaseDomain((BaseDomain)agreement);
        agreement.setAppId(appId);
        agreement.setTitle(title);
        agreement.setCode(code);
        agreement.setContent(content);
        agreement.setSortNumber(sortNumber);
        return agreement;
    }

    @Transactional
    public void insertAgreement(Agreement agreementGtDb) {
        Content content = new Content();
        content.setId(SequenceUtil.createUuid());
        content.setAppId(agreementGtDb.getAppId());
        content.setContent(agreementGtDb.getContent());
        this.contentMapper.insert(content);
        agreementGtDb.setContentId(content.getId());
        this.agreementMapper.insert((Object)agreementGtDb);
    }

    @Transactional
    public void deleteAgreementAndContent(Agreement agreementDb) {
        this.contentMapper.deleteById(agreementDb.getContentId());
        this.agreementMapper.deleteById(agreementDb.getId());
    }

    @Transactional
    public void updateAgreementAndContent(Agreement agreementGtDb) {
        this.agreementMapper.updateSelective((Object)agreementGtDb);
        Content content = new Content();
        content.setId(agreementGtDb.getContentId());
        content.setContent(agreementGtDb.getContent());
        this.contentMapper.updateSelective(content);
    }

    public List<Agreement> selectAdminPage(String code, String appId, Page page) {
        if (StringUtil.isNotBlank((String)code)) {
            page.eq("code", (Object)code);
        }
        page.eq("appId", (Object)appId);
        page.orderBy("code asc,sortNumber asc");
        return this.agreementMapper.selectPage(page);
    }

    public Agreement selectById(String id, String appId) {
        return (Agreement)((Object)this.agreementMapper.select(JpaCriteria.builder().eq("id", (Object)id).eq("appId", (Object)appId)));
    }
}

