/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.wego168.base.config.AliyunOssStorageConfig;
import com.wego168.base.model.response.FileUploadResponse;
import com.wego168.base.service.facade.IStorageService;
import com.wego168.exception.HttpException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOssStorageService
implements IStorageService {
    Logger logger = LoggerFactory.getLogger(AliyunOssStorageService.class);
    AliyunOssStorageConfig config;
    OSS oss;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(AliyunOssStorageConfig config) {
        if (this.oss != null || config == null) return;
        Class<AliyunOssStorageService> clazz = AliyunOssStorageService.class;
        synchronized (AliyunOssStorageService.class) {
            if (this.oss != null || config == null) return;
            String endpoint = config.getEndpoint();
            String bucket = config.getBucketName();
            if (StringUtil.isNotBlank((String)bucket)) {
                endpoint = endpoint.replace(bucket + ".", "");
            }
            String accessKeyId = config.getAccessKeyId();
            String accessKeySecret = config.getAccessKeySecret();
            this.oss = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
            this.config = config;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public FileUploadResponse put(String bucket, String filePathAndName, InputStream in, Map<String, String> metaData) {
        Checker.checkCondition((boolean)filePathAndName.startsWith("/"), (String)"\u8def\u5f84\u4e0d\u80fd\u4ee5/\u5f00\u5934\uff01");
        if (StringUtil.isBlank((String)bucket)) {
            bucket = this.config.getBucketName();
        }
        this.oss.putObject(bucket, filePathAndName, in);
        FileUploadResponse response = new FileUploadResponse();
        response.setHost(this.config.getEndpoint());
        response.setUrl("/" + filePathAndName);
        try {
            response.setSize(Long.valueOf(in.available()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUploadResponse put(String bucket, String filePathAndName, byte[] fileBytes, Map<String, String> metaData) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(fileBytes);){
            FileUploadResponse fileUploadResponse = this.put(bucket, filePathAndName, in, metaData);
            return fileUploadResponse;
        }
        catch (IOException e) {
            this.logger.error("\u963f\u91cc\u4e91\u4e0a\u4f20oss\u5173\u95ed\u5b57\u8282\u6d41\u5931\u8d25");
            throw HttpException.writeError();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUploadResponse put(String bucket, String filePathAndName, File localFile, Map<String, String> metaData) {
        try (FileInputStream in = new FileInputStream(localFile);){
            FileUploadResponse fileUploadResponse = this.put(bucket, filePathAndName, in, metaData);
            return fileUploadResponse;
        }
        catch (IOException e) {
            this.logger.error("\u963f\u91cc\u4e91\u4e0a\u4f20oss\u5173\u95ed\u5b57\u8282\u6d41\u5931\u8d25");
            throw HttpException.writeError();
        }
    }

    @Override
    public FileUploadResponse simplePut(String filePathAndName, InputStream in) {
        return this.put(null, filePathAndName, in, null);
    }

    @Override
    public FileUploadResponse simplePut(String filePathAndName, byte[] bytes) {
        return this.put(null, filePathAndName, bytes, null);
    }

    @Override
    public FileUploadResponse simplePut(String filePathAndName, File localFile) {
        return this.put(null, filePathAndName, localFile, null);
    }
}

