/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.AppAbility;
import com.wego168.base.domain.AppAbilityTemplate;
import com.wego168.base.enums.AppAbilityShowTypeEnum;
import com.wego168.base.model.response.AppAbilityResponse;
import com.wego168.base.persistence.AppAbilityMapper;
import com.wego168.base.service.AppAbilityTemplateService;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppAbilityService
extends CrudService<AppAbility> {
    @Autowired
    private AppAbilityMapper mapper;
    @Autowired
    private AppAbilityTemplateService appAbilityTemplateService;

    public CrudMapper<AppAbility> getMapper() {
        return this.mapper;
    }

    public List<AppAbilityResponse> getTree(String appId) {
        List<AppAbility> fullList = this.selectFullList(appId);
        Checker.checkCondition((boolean)Checker.listIsEmpty(fullList), (String)"\u914d\u7f6e\u672a\u5f00\u542f");
        ArrayList<AppAbilityResponse> responseList = new ArrayList<AppAbilityResponse>();
        for (AppAbility ability : fullList) {
            if (ability.getLevel() != 1) continue;
            responseList.add(this.getAbility(ability.getCode(), fullList));
        }
        return responseList;
    }

    public AppAbility selectByCode(String appId, String code) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.eq("code", (Object)code);
        AppAbility ability = (AppAbility)this.mapper.select(criteria);
        if (ability == null) {
            this.selectFullList(appId);
            ability = (AppAbility)this.mapper.select(criteria);
        }
        return ability;
    }

    public Map<String, Boolean> selectAbilityStatus(String appId, String code) {
        String rootCode = code.split("-")[0];
        LinkedHashMap<String, Boolean> statusMap = new LinkedHashMap<String, Boolean>();
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.leftLike("code", (Object)rootCode);
        criteria.orderBy("level ASC, code ASC");
        List list = this.mapper.selectList(criteria);
        if (Checker.listNotEmpty((List)list)) {
            String abilityCode;
            HashMap<String, AppAbility> abilityMap = new HashMap<String, AppAbility>();
            for (AppAbility ability : list) {
                abilityCode = ability.getCode();
                abilityMap.put(abilityCode, ability);
            }
            for (AppAbility ability : list) {
                abilityCode = ability.getCode();
                if (!abilityCode.startsWith(code)) continue;
                boolean isOpen = this.isOpen(ability, abilityMap);
                statusMap.put(ability.getCode(), isOpen);
            }
        }
        return statusMap;
    }

    public boolean isOpen(String appId, String code) {
        Map<String, Boolean> abilityStatusMap = this.selectAbilityStatus(appId, code);
        return abilityStatusMap.getOrDefault(code, false);
    }

    public void updateValueByCode(String appId, String code, String value) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.eq("code", (Object)code);
        criteria.set("value", (Object)value);
        this.mapper.updateSelective(criteria);
    }

    private boolean isOpen(AppAbility ability, Map<String, AppAbility> abilityMap) {
        if (this.isOpen(ability)) {
            String parentCode = ability.getParentCode();
            if (StringUtil.isBlank((String)parentCode)) {
                return this.isOpen(ability);
            }
            AppAbility parentAbility = abilityMap.get(parentCode);
            if (parentAbility == null) {
                return this.isOpen(ability);
            }
            return this.isOpen(parentAbility, abilityMap);
        }
        return false;
    }

    private boolean isOpen(AppAbility ability) {
        String showType = ability.getShowType();
        if (StringUtil.equals((String)showType, (String)AppAbilityShowTypeEnum.CHECKBOX.value())) {
            return StringUtil.equals((String)ability.getValue(), (String)"checked");
        }
        return false;
    }

    private AppAbilityResponse getAbility(String code, List<AppAbility> fullList) {
        Checker.checkCondition((boolean)Checker.listIsEmpty(fullList), (String)"\u79ef\u5206\u914d\u7f6e\u672a\u5f00\u542f");
        AppAbilityResponse root = null;
        for (AppAbility ability : fullList) {
            List<AppAbilityResponse> children;
            int level;
            if (StringUtil.equals((String)ability.getCode(), (String)code)) {
                root = new AppAbilityResponse(ability);
            }
            if ((level = ability.getLevel().intValue()) == 2 && StringUtil.equals((String)ability.getParentCode(), (String)code)) {
                children = root.getChildren();
                if (children == null) {
                    children = new ArrayList<AppAbilityResponse>();
                }
                children.add(new AppAbilityResponse(ability));
                root.setChildren(children);
            }
            if (level != 3 || !Checker.listNotEmpty(children = root.getChildren())) continue;
            for (AppAbilityResponse subChild : children) {
                if (!StringUtil.equals((String)subChild.getCode(), (String)ability.getParentCode())) continue;
                List<AppAbilityResponse> subChildren = subChild.getChildren();
                if (subChildren == null) {
                    subChildren = new ArrayList<AppAbilityResponse>();
                }
                subChildren.add(new AppAbilityResponse(ability));
                subChild.setChildren(subChildren);
            }
        }
        return root;
    }

    private boolean fillByTemplate(List<AppAbility> list, Map<String, AppAbilityTemplate> templateMap, String appId) {
        boolean addedNew = false;
        HashMap<String, AppAbility> map = new HashMap<String, AppAbility>();
        if (Checker.listNotEmpty(list)) {
            for (AppAbility appAbility : list) {
                map.put(appAbility.getCode(), appAbility);
            }
        }
        ArrayList<AppAbility> newAbilityToBeAdded = new ArrayList<AppAbility>();
        for (Map.Entry<String, AppAbilityTemplate> entry : templateMap.entrySet()) {
            String templateCode = entry.getKey();
            AppAbilityTemplate template = entry.getValue();
            if (map.containsKey(templateCode)) continue;
            AppAbility ability = this.fromTemplate(template, appId);
            newAbilityToBeAdded.add(ability);
            addedNew = true;
        }
        if (Checker.listNotEmpty(newAbilityToBeAdded)) {
            this.mapper.insertBatch(newAbilityToBeAdded);
        }
        return addedNew;
    }

    public AppAbility fromTemplate(AppAbilityTemplate template, String appId) {
        AppAbility ability = new AppAbility();
        BaseDomainUtil.initBaseDomain((BaseDomain)ability, (String)appId);
        ability.setCode(template.getCode());
        ability.setDescription(template.getDescription());
        ability.setIcon(template.getIcon());
        ability.setLevel(template.getLevel());
        ability.setName(template.getName());
        ability.setParentCode(template.getParentCode());
        ability.setServerId(template.getServerId());
        ability.setShowType(template.getShowType());
        ability.setSortNumber(template.getSortNumber());
        ability.setValue(template.getValue());
        ability.setValueRange(null);
        return ability;
    }

    private List<AppAbility> selectFullList(String appId) {
        Map<String, AppAbilityTemplate> templateMap = this.appAbilityTemplateService.selectAsMap();
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.orderBy("level ASC, sortNumber ASC");
        List list = this.mapper.selectList(criteria);
        if (templateMap.size() > 0 && this.fillByTemplate(list, templateMap, appId)) {
            return this.selectFullList(appId);
        }
        return list;
    }
}

