/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.AppAbilityTemplate;
import com.wego168.base.persistence.AppAbilityTemplateMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppAbilityTemplateService
extends BaseService<AppAbilityTemplate> {
    @Autowired
    private AppAbilityTemplateMapper mapper;

    public CrudMapper<AppAbilityTemplate> getMapper() {
        return this.mapper;
    }

    public AppAbilityTemplate create(int level, String name, String code, String description, String icon, String parentCode, String serverId, int sortNumber, String showType, String value, String valueRange) {
        AppAbilityTemplate template = new AppAbilityTemplate();
        template.setCode(code);
        template.setDescription(description);
        if (StringUtil.isNotBlank((String)icon)) {
            template.setIcon(icon);
        }
        template.setId(SequenceUtil.createUuid());
        template.setLevel(level);
        template.setName(name);
        if (StringUtil.isNotBlank((String)parentCode)) {
            template.setParentCode(parentCode);
        }
        template.setServerId(serverId);
        template.setShowType(showType);
        template.setSortNumber(sortNumber);
        if (StringUtil.isNotBlank((String)value)) {
            template.setValue(value);
        }
        if (StringUtil.isNotBlank((String)valueRange)) {
            template.setValueRange(valueRange);
        }
        return template;
    }

    public boolean existSameCode(String code) {
        return this.selectByCode(code) != null;
    }

    public AppAbilityTemplate selectByCode(String code) {
        return (AppAbilityTemplate)this.mapper.select(JpaCriteria.builder().eq("code", (Object)code));
    }

    @Transactional
    public void deleteByCode(String code) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.leftLike("code", (Object)code);
        this.mapper.delete(criteria);
    }

    public Map<String, AppAbilityTemplate> selectAsMap() {
        HashMap<String, AppAbilityTemplate> map = new HashMap<String, AppAbilityTemplate>();
        List list = this.mapper.selectList(JpaCriteria.builder());
        if (Checker.listNotEmpty((List)list)) {
            for (AppAbilityTemplate template : list) {
                map.put(template.getCode(), template);
            }
        }
        return map;
    }

    private String transferOrderBy(String orderBy, String alias) {
        String tableName = "";
        if (StringUtil.isNotBlank((String)alias)) {
            tableName = alias;
        }
        if (StringUtil.equals((String)orderBy, (String)"smallSortNumberFirst")) {
            return tableName + "sort_number ASC";
        }
        return tableName + "sort_number ASC";
    }
}

