/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.App;
import com.wego168.base.enums.AppStatusEnum;
import com.wego168.base.persistence.AppMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.service.InitApp;
import com.wego168.service.InitializingBeanHandler;
import com.wego168.util.Shift;
import com.wego168.web.util.GuidGenerator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppService
extends CrudService<App>
implements InitializingBeanHandler {
    @Autowired
    private AppMapper appMapper;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;

    public CrudMapper<App> getMapper() {
        return this.appMapper;
    }

    public App createApp(String id, String appName, String customerName, String logUrl, Date endDate) {
        String code = null;
        try {
            code = this.makeCode(appName);
        }
        catch (PinyinException e) {
            e.printStackTrace();
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            id = GuidGenerator.generate();
        }
        App app = new App();
        Date date = new Date();
        app.setId(id);
        app.setAppId(id);
        app.setCode(code);
        app.setName(appName);
        app.setCustomerName(customerName);
        app.setLogUrl(logUrl);
        app.setStatus(AppStatusEnum.NORMAL.value());
        app.setIsDeleted(false);
        app.setCreateTime(date);
        app.setEndDate(endDate);
        this.insert((Object)app);
        this.simpleRedisTemplate.set(app.getCode(), (Object)app);
        InitApp.initByAppId((String)id);
        return app;
    }

    public String makeCode(String appName) throws PinyinException {
        String code = null;
        App vo = null;
        int i = 0;
        int nameLength = appName.length();
        do {
            if (i == 0) {
                code = PinyinHelper.getShortPinyin((String)appName).toLowerCase();
            } else if (i <= nameLength) {
                String front = appName.substring(0, i);
                String later = appName.substring(i, nameLength);
                code = PinyinHelper.convertToPinyinString((String)front, (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE).toLowerCase() + PinyinHelper.getShortPinyin((String)later).toLowerCase();
            } else {
                code = PinyinHelper.convertToPinyinString((String)appName, (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE).toLowerCase() + String.valueOf(i - nameLength);
            }
            ++i;
            vo = this.getCacheByCode(code);
            if (vo != null) continue;
            vo = this.selectByCode(code);
        } while (vo != null);
        return code;
    }

    public App selectByAppId(String appId) {
        return (App)((Object)this.appMapper.select(JpaCriteria.builder().eq("appId", (Object)appId)));
    }

    public String getCodeByAppId(String appId) {
        App app = (App)((Object)this.simpleRedisTemplate.get(appId, App.class));
        if (app == null) {
            app = this.selectByAppId(appId);
            Shift.throwsIfNull((Object)((Object)app), (String)"\u83b7\u53d6\u5e94\u7528\u5931\u8d25");
        }
        return app.getCode();
    }

    public App selectByCode(String code) {
        return (App)((Object)this.appMapper.select(JpaCriteria.builder().eq("code", (Object)code)));
    }

    public App getCacheByCode(String code) {
        return (App)((Object)this.simpleRedisTemplate.get(code, App.class));
    }

    public void invoking() {
        List lists = this.appMapper.selectList(JpaCriteria.builder().eq("isDeleted", (Object)false));
        if (lists != null && lists.size() > 0) {
            for (App app : lists) {
                this.setCache(app);
            }
        }
    }

    public void setCache(App app) {
        this.simpleRedisTemplate.set(app.getCode(), (Object)app);
        this.simpleRedisTemplate.set(app.getAppId(), (Object)app);
    }

    public void updateAppStatus() {
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        this.appMapper.updateAppStatus(date, AppStatusEnum.NORMAL.value(), AppStatusEnum.EXPIRE.value());
    }

    public void updateApp(App app) {
        int count = this.selectCount(JpaCriteria.builder().eq("code", (Object)app.getCode()).ne("id", (Object)app.getId()));
        Shift.throwsIfInvalid((count > 0 ? 1 : 0) != 0, (String)"\u7f16\u53f7\u5df2\u5b58\u5728");
        app.setUpdateTime(new Date());
        if (app.getEndDate().getTime() <= new Date().getTime()) {
            app.setStatus(AppStatusEnum.EXPIRE.value());
        } else {
            app.setStatus(AppStatusEnum.NORMAL.value());
        }
        super.updateSelective((Object)app);
        this.simpleRedisTemplate.set(app.getCode(), (Object)app);
    }

    public List<App> selectRunningApp() {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("status", (Object)AppStatusEnum.NORMAL.value()).gt("endDate", (Object)new Date());
        return this.appMapper.selectList(criteria);
    }
}

