/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.wego168.base.domain.AppWechatConfig;
import com.wego168.base.domain.Content;
import com.wego168.base.persistence.AppWechatConfigMapper;
import com.wego168.base.persistence.ContentMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.web.util.GuidGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppWechatConfigService
extends CrudService<AppWechatConfig> {
    @Autowired
    private AppWechatConfigMapper appWechatConfigMapper;
    @Autowired
    private ContentMapper contentMapper;

    public CrudMapper<AppWechatConfig> getMapper() {
        return this.appWechatConfigMapper;
    }

    private AppWechatConfig createDefaultConfig(String id) {
        AppWechatConfig defaultConfig = new AppWechatConfig();
        BaseDomainUtil.initBaseDomain((BaseDomain)defaultConfig);
        defaultConfig.setId(id);
        defaultConfig.setAppId(id);
        defaultConfig.setIsSubscribeGuidenceEnabled(false);
        defaultConfig.setWechatSubscribeQrcode(null);
        return defaultConfig;
    }

    public AppWechatConfig selectById(String id) {
        AppWechatConfig config = (AppWechatConfig)((Object)this.appWechatConfigMapper.selectById(id));
        if (config == null) {
            AppWechatConfig defaultConfig = this.createDefaultConfig(id);
            this.appWechatConfigMapper.insert((Object)defaultConfig);
            return defaultConfig;
        }
        if (StringUtils.isNotBlank((CharSequence)config.getWxPayAgreementContentId())) {
            Content wxPayAgreementContent = (Content)this.contentMapper.selectById(config.getWxPayAgreementContentId());
            config.setWxPayAgreementContent(wxPayAgreementContent.getContent());
        }
        return config;
    }

    public int update(String wechatSubscribeQrcode, boolean isSubscribeGuidenceEnabled, String id) {
        AppWechatConfig config = new AppWechatConfig();
        config.setIsSubscribeGuidenceEnabled(isSubscribeGuidenceEnabled);
        config.setWechatSubscribeQrcode(wechatSubscribeQrcode);
        config.setId(id);
        return this.appWechatConfigMapper.updateSelective((Object)config);
    }

    @Transactional
    public void updates(AppWechatConfig config) {
        if (config.getIsOpenWxPayAgreement() == null) {
            config.setIsOpenWxPayAgreement(false);
        }
        if (config.getIsOpenWxPayAgreement().booleanValue() && StringUtils.isNotBlank((CharSequence)config.getWxPayAgreementContent())) {
            String contentId = config.getWxPayAgreementContentId();
            Content content = new Content();
            content.setContent(config.getWxPayAgreementContent());
            if (StringUtils.isNotBlank((CharSequence)contentId)) {
                content.setId(contentId);
                this.contentMapper.updateSelective(content);
            } else {
                content.setId(GuidGenerator.generate());
                content.setAppId(config.getAppId());
                this.contentMapper.insert(content);
                config.setWxPayAgreementContentId(content.getId());
            }
        }
        this.appWechatConfigMapper.updateSelective((Object)config);
    }
}

