/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Area;
import com.wego168.base.persistence.AreaMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AreaService
extends BaseService<Area> {
    @Autowired
    private AreaMapper areaMapper;

    public CrudMapper<Area> getMapper() {
        return this.areaMapper;
    }

    @Transactional
    public void insertAreaList(Area vo) {
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            super.insert((Object)vo);
        }
        List<Area> childList = vo.getChildList();
        for (Area area : childList) {
            area.setParentId(vo.getId());
        }
        super.insertBatch(childList);
    }

    public Area qyeryAndSetHasChild(Area area) {
        if (area != null) {
            boolean hasChild = this.queryHasChild(area.getId());
            area.setHasChild(hasChild);
        }
        return area;
    }

    public List<Area> qyeryAndSetHasChildByList(List<Area> areas) {
        if (areas == null || areas.size() <= 0) {
            return areas;
        }
        for (Area item : areas) {
            if (item == null) continue;
            boolean hasChild = this.queryHasChild(item.getId());
            item.setHasChild(hasChild);
        }
        return areas;
    }

    public boolean queryHasChild(String id) {
        Integer count = (Integer)this.select(JpaCriteria.builder().select("count(*)").eq("parentId", (Object)id), Integer.class);
        return count > 0;
    }
}

