/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.CalendarEvent;
import com.wego168.base.persistence.CalendarEventMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CalendarEventService
extends BaseService<CalendarEvent> {
    @Autowired
    private CalendarEventMapper calendarEventMapper;

    public CrudMapper<CalendarEvent> getMapper() {
        return this.calendarEventMapper;
    }

    public List<CalendarEvent> selectPage(Page page) {
        page.eq("sourceId").eq("sourceType").leftLike("startTime").orderBy("start_time");
        return super.selectPage(page);
    }

    public CalendarEvent selectBySourceId(String sourceId) {
        return (CalendarEvent)((Object)this.calendarEventMapper.select(JpaCriteria.builder().eq("sourceId", (Object)sourceId)));
    }

    public Date getRemaindTime(Date startTime, String value, String aheadTime) {
        String[] valueArray = value.split("_");
        String earliestTimeString = valueArray[1];
        String latestTimeString = valueArray[2];
        Date remaindTime = DateUtil.addSecondsToDate((Date)startTime, (int)(-Integer.valueOf(aheadTime).intValue() * 60));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), Integer.valueOf(earliestTimeString.split(":")[0]), Integer.valueOf(earliestTimeString.split(":")[1]), 0);
        Date earliestTime = calendar.getTime();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), Integer.valueOf(latestTimeString.split(":")[0]), Integer.valueOf(latestTimeString.split(":")[1]), 0);
        Date latestTime = calendar.getTime();
        if (remaindTime.before(earliestTime)) {
            remaindTime = DateUtil.addDaysToDate((Date)latestTime, (int)-1);
            return remaindTime;
        }
        if (remaindTime.after(latestTime)) {
            remaindTime = latestTime;
            return remaindTime;
        }
        return remaindTime;
    }
}

