/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Category;
import com.wego168.base.persistence.CategoryMapper;
import com.wego168.base.service.facade.DictCodeHandler;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.AppCopyHandler;
import com.wego168.service.BaseService;
import com.wego168.service.InitAppHandler;
import com.wego168.service.InitializingBeanHandler;
import com.wego168.util.AppCopyUtil;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.Shift;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CategoryService
extends BaseService<Category>
implements DictCodeHandler<Category>,
InitAppHandler,
InitializingBeanHandler,
AppCopyHandler {
    private static final Logger log = LoggerFactory.getLogger(CategoryService.class);
    @Autowired
    private CategoryMapper categoryMapper;

    @Override
    public CrudMapper<Category> getMapper() {
        return this.categoryMapper;
    }

    private static Category create(String appId, int type, String code, String name, String iconUrl, String parentId, String info, int seqNum) {
        Category c = new Category();
        BaseDomainUtil.initBaseDomain((BaseDomain)c);
        c.setAppId(appId);
        c.setType(type);
        c.setCode(code);
        c.setName(name);
        c.setIconUrl(iconUrl);
        c.setParentId(parentId);
        c.setInfo(info);
        c.setSeqNum(seqNum);
        c.setIsDeleted(false);
        c.setIsHasChild(false);
        c.setIsDisplay(true);
        return c;
    }

    public void init(String appId) {
        this.init(appId, "2_7_3_8");
    }

    public int init(String appId, String type) {
        Category c;
        int num = 0;
        LinkedList<Category> list = new LinkedList<Category>();
        String parentId = "0";
        Map<String, Category> categoryMap = this.selectMapByParentId(parentId, appId);
        if (StringUtils.contains((CharSequence)type, (CharSequence)"2") && !categoryMap.containsKey("act")) {
            c = CategoryService.create(appId, 2, "act", "\u6d3b\u52a8", "", parentId, "\u6d3b\u52a8\u57fa\u7840\u5206\u7c7b\u8282\u70b9", 0);
            list.add(c);
            ++num;
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"3") && !categoryMap.containsKey("course")) {
            c = CategoryService.create(appId, 3, "course", "\u8bfe\u7a0b", "", parentId, "\u8bfe\u7a0b\u57fa\u7840\u5206\u7c7b\u8282\u70b9", 0);
            list.add(c);
            ++num;
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"7") && !categoryMap.containsKey("index_rolling_picture")) {
            c = CategoryService.create(appId, 7, "index_rolling_picture", "\u9996\u9875\u8f6e\u64ad\u56fe", "", parentId, "\u9996\u9875\u8f6e\u64ad\u56fe\u8282\u70b9", 0);
            list.add(c);
            ++num;
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"8") && !categoryMap.containsKey("news")) {
            c = CategoryService.create(appId, 8, "news", "\u56fe\u6587", "", parentId, "\u56fe\u6587\u57fa\u7840\u5206\u7c7b\u8282\u70b9", 0);
            list.add(c);
            ++num;
        }
        if (list.size() > 0) {
            this.insertBatch(list);
        }
        return num;
    }

    public List<Category> selectPage(Page page) {
        page.eq("parentId").eq("code").eq("type").like("name").orderBy("seqNum asc");
        return super.selectPage(page);
    }

    public List<Category> selectListByParentId(String parentId) {
        List list = super.selectList(JpaCriteria.builder().eq("parentId", (Object)parentId));
        return list;
    }

    private Map<String, Category> selectMapByParentId(String parentId, String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("parentId", (Object)parentId);
        criteria.eq("appId", (Object)appId);
        List list = this.selectList(criteria);
        HashMap<String, Category> map = new HashMap<String, Category>();
        if (Checker.listNotEmpty((List)list)) {
            for (Category category : list) {
                map.put(category.getCode(), category);
            }
        }
        return map;
    }

    public List<Category> selectListByParentIdAll(String parentId) {
        List list = super.selectList(JpaCriteria.builder().eq("parentId", (Object)parentId).eq("isDisplay", (Object)true));
        return list;
    }

    public Category selectByCode(String code) {
        return (Category)this.selectByCode(code, this.getAppId());
    }

    public List<Category> listByType(Integer type) {
        return super.selectList(JpaCriteria.builder().eq("type", (Object)type).eq("isDisplay", (Object)true).orderBy("seqNum asc, createTime desc"));
    }

    public List<Category> listByTypeAll(Integer type) {
        return super.selectList(JpaCriteria.builder().eq("type", (Object)type).orderBy("seqNum asc, createTime desc"));
    }

    public List<Category> listByTypeAll(Category category) {
        JpaCriteria criteria = JpaCriteria.builder().eq("type", (Object)category.getType()).orderBy("seqNum asc, createTime desc");
        if (StringUtils.isNotBlank((CharSequence)category.getName())) {
            criteria.like("name", (Object)category.getName());
        }
        return super.selectList(criteria);
    }

    public List<Category> listByTypeAndParent(Integer type, String storeId, String parentId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("type", (Object)type).eq("parentId", (Object)parentId).eq("isDisplay", (Object)true).eq("isDeleted", (Object)false).orderBy("seqNum asc, createTime desc");
        if (StringUtils.isNotBlank((CharSequence)storeId)) {
            criteria.eq("storeId", (Object)storeId);
        }
        return super.selectList(criteria);
    }

    public List<Category> listFirstChildsByType(Integer type) {
        return this.categoryMapper.listFirstChildsByType(type, this.getAppId());
    }

    public List<Category> listChildsByType(Integer type) {
        return this.categoryMapper.selectList(JpaCriteria.builder().eq("isDisplay", (Object)true).eq("type", (Object)type).ne("parentId", (Object)"0").orderBy("seqNum asc"));
    }

    @Transactional
    public int insert(Category o) {
        int row;
        o.setIsHasChild(false);
        if (StringUtils.isBlank((CharSequence)o.getParentId())) {
            o.setParentId("0");
        }
        if (!"0".equals(o.getParentId())) {
            row = this.categoryMapper.updateSelective(JpaCriteria.builder().set("isHasChild", (Object)true).eq("id", (Object)o.getParentId()));
            Shift.throwsIfInvalid((row == 0 ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u8be5\u7c7b\u522b\u7684\u7236\u8282\u70b9");
        }
        if ((row = super.insert((Object)o)) == 1) {
            // empty if block
        }
        return row;
    }

    public int update(Category o) {
        int row = super.update((Object)o);
        if (row == 1) {
            // empty if block
        }
        return row;
    }

    @Transactional
    public int updateDelete(String id) {
        Map<String, Object> map = this.categoryMapper.getParentIdJoinNumById(id);
        if (map != null && map.containsKey("num")) {
            int num = Integer.valueOf(map.get("num").toString());
            String parentId = String.valueOf(map.get("parentId"));
            if (num > 1) {
                this.categoryMapper.updateSelective(JpaCriteria.builder().set("isHasChild", (Object)true).eq("id", (Object)parentId));
            }
        }
        return super.updateDelete((Object)id);
    }

    public void invoking() {
        List list = this.categoryMapper.selectList(JpaCriteria.builder().eq("isDeleted", (Object)false).ne("parentId", (Object)"0"));
        this.initParentCache(list);
    }

    @Deprecated
    @Transactional
    public void editCategoryList(List<Category> list, Integer type) {
        List oldList = super.selectList(JpaCriteria.builder().eq("type", (Object)type).eq("isDeleted", (Object)false));
        if (oldList != null && oldList.size() > 0) {
            HashMap<String, Category> map = new HashMap<String, Category>();
            for (Category oldCategory : oldList) {
                map.put(oldCategory.getId(), oldCategory);
            }
            for (Category newCategory : list) {
                if (!StringUtils.isBlank((CharSequence)newCategory.getId())) {
                    String key = newCategory.getId();
                    if (!map.containsKey(key)) continue;
                    newCategory.setUpdateTime(new Date());
                    this.categoryMapper.updateSelective(newCategory);
                    map.remove(key);
                    continue;
                }
                super.insert((Object)newCategory);
            }
            if (map.size() > 0) {
                for (String key : map.keySet()) {
                    Category category = (Category)map.get(key);
                    category.setIsDeleted(true);
                    category.setUpdateTime(new Date());
                    this.categoryMapper.updateSelective(category);
                }
            }
        } else {
            super.insertBatch(list);
        }
    }

    public void copyData(String sourceAppId, String targetAppId) {
        LinkedList<Category> list = this.categoryMapper.selectList(JpaCriteria.builder().eq("appId", (Object)sourceAppId).eq("isDeleted", (Object)false));
        List oldList = this.categoryMapper.selectList(JpaCriteria.builder().eq("appId", (Object)targetAppId).eq("isDeleted", (Object)false));
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (!oldList.isEmpty()) {
            HashMap<String, String> nameMap = new HashMap<String, String>();
            for (Category c : oldList) {
                nameMap.put(c.getName(), c.getId());
            }
            LinkedList<Category> addList = new LinkedList<Category>();
            for (Category c : list) {
                String id = (String)nameMap.get(c.getName());
                if (StringUtils.isNotBlank((CharSequence)id)) {
                    idMap.put(c.getId(), id);
                    continue;
                }
                addList.add(c);
            }
            list = addList;
        }
        if (!list.isEmpty()) {
            AppCopyUtil.copyDataAndHandleParent((List)list, idMap, (String)targetAppId, (String)"parentId");
            this.categoryMapper.insertBatch(list);
        }
        log.error("\u5171\u590d\u5236{}\u884cCategory\u6570\u636e", (Object)list.size());
    }
}

