/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Comment;
import com.wego168.base.domain.Commentable;
import com.wego168.base.enums.CommentAuditStatusEnum;
import com.wego168.base.persistence.CommentMapper;
import com.wego168.base.service.callback.Callback;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommentService
extends CrudService<Comment> {
    private static final Logger log = LoggerFactory.getLogger(CommentService.class);
    public static final String top = "11111111111111111111111111111111";
    @Autowired
    private CommentMapper commentMapper;

    public CrudMapper<Comment> getMapper() {
        return this.commentMapper;
    }

    public Comment createByOpenId(String content, String openId, String sourceId, String parentId, int sourceType, Integer auditStatus, String appId) {
        Comment comment = new Comment();
        BaseDomainUtil.initBaseDomain((BaseDomain)comment);
        comment.setAppId(appId);
        comment.setOpenId(openId);
        comment.setAuditBy(null);
        comment.setAuditStatus(auditStatus);
        comment.setAuditTime(null);
        comment.setContent(content);
        comment.setIsAnonymous(false);
        if (StringUtil.isBlank((String)parentId)) {
            parentId = top;
        }
        comment.setParentId(parentId);
        comment.setPraiseQuantity(0);
        comment.setSourceId(sourceId);
        comment.setSourceType(sourceType);
        return comment;
    }

    public Comment create(String content, String memberId, String sourceId, String parentId, int sourceType, Integer auditStatus, String appId) {
        Comment comment = new Comment();
        BaseDomainUtil.initBaseDomain((BaseDomain)comment);
        comment.setAppId(appId);
        comment.setAuditBy(null);
        comment.setAuditStatus(auditStatus);
        comment.setAuditTime(null);
        comment.setContent(content);
        comment.setIsAnonymous(false);
        comment.setMemberId(memberId);
        if (StringUtil.isBlank((String)parentId)) {
            parentId = top;
        }
        comment.setParentId(parentId);
        comment.setPraiseQuantity(0);
        comment.setSourceId(sourceId);
        comment.setSourceType(sourceType);
        return comment;
    }

    public Comment selectById(String id) {
        JpaCriteria criteria = JpaCriteria.builder().eq("id", (Object)id).eq("isDeleted", (Object)false);
        return (Comment)((Object)this.commentMapper.select(criteria));
    }

    public Comment selectById(String id, String memberId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("id", (Object)id).eq("memberId", (Object)memberId);
        return (Comment)((Object)this.commentMapper.select(criteria));
    }

    public void auditComment(String id, String auditBy) {
        Comment comment = new Comment();
        comment.setId(id);
        comment.setAuditBy(auditBy);
        comment.setAuditStatus(CommentAuditStatusEnum.AUDITED.value());
        comment.setAuditTime(new Date());
        this.commentMapper.updateSelective((Object)comment);
    }

    public void refuseComment(String id, String auditBy) {
        Comment comment = new Comment();
        comment.setId(id);
        comment.setAuditBy(auditBy);
        comment.setAuditStatus(CommentAuditStatusEnum.REFUSED.value());
        this.commentMapper.updateSelective((Object)comment);
    }

    public List<Comment> selectPages(Page page) {
        return this.commentMapper.selectPages(page);
    }

    public List<Comment> selectPage(String sourceId, Integer auditStatus, Page page) {
        List<Comment> subComments;
        page.put((Object)"sourceId", (Object)sourceId);
        if (auditStatus != null) {
            page.put((Object)"auditStatus", (Object)auditStatus);
        }
        page.put((Object)"parentId", (Object)top);
        List<Comment> list = this.commentMapper.selectPage(page);
        if (list != null && list.size() > 0 && (subComments = this.commentMapper.selectSubComments(auditStatus, list)) != null && subComments.size() > 0) {
            block0: for (Comment subComment : subComments) {
                String parentId = subComment.getParentId();
                for (Comment comment : list) {
                    if (!StringUtil.equals((String)parentId, (String)comment.getId())) continue;
                    List<Comment> thisSubComments = comment.getSubComments();
                    if (thisSubComments == null) {
                        thisSubComments = new ArrayList<Comment>(30);
                    }
                    thisSubComments.add(subComment);
                    comment.setSubComments(thisSubComments);
                    continue block0;
                }
            }
        }
        return list;
    }

    public List<Comment> selectPageWithoutSubComments(String sourceId, Integer auditStatus, Page page) {
        page.put((Object)"sourceId", (Object)sourceId);
        if (auditStatus != null) {
            page.put((Object)"auditStatus", (Object)auditStatus);
        }
        page.put((Object)"parentId", (Object)top);
        List<Comment> list = this.commentMapper.selectPageWithoutSubComments(page);
        return list;
    }

    public List<Comment> selectListByParentId(String parentId) {
        return this.commentMapper.selectListByParentId(parentId);
    }

    public int countBySourceId(String sourceId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("sourceId", (Object)sourceId);
        return super.selectCount(criteria);
    }

    public void deleteById(String id) {
        Comment comment = new Comment();
        comment.setId(id);
        comment.setIsDeleted(true);
        this.commentMapper.updateSelective((Object)comment);
    }

    @Transactional
    public void addComment(Comment comment, Commentable commentable, Callback<Commentable> callback) {
        this.commentMapper.insert((Object)comment);
        callback.execute(commentable);
    }

    @Transactional
    public void deleteComment(String id, Commentable commentable, Callback<Commentable> callback) {
        this.deleteById(id);
        callback.execute(commentable);
    }

    public int updateCommentQuantity(Commentable commentable) {
        return this.commentMapper.updateSelective(commentable);
    }
}

