/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Config;
import com.wego168.base.enums.ConfigEnum;
import com.wego168.base.enums.ConfigTypeEnum;
import com.wego168.base.model.interfaces.HasConfigKey;
import com.wego168.base.persistence.ConfigMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.AppCopyHandler;
import com.wego168.service.BaseService;
import com.wego168.service.InitAppHandler;
import com.wego168.service.InitializingBeanHandler;
import com.wego168.util.AppCopyUtil;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigService
extends BaseService<Config>
implements InitializingBeanHandler,
InitAppHandler,
AppCopyHandler {
    private static final Logger log = LoggerFactory.getLogger(ConfigService.class);
    @Autowired
    private ConfigMapper configMapper;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;

    public CrudMapper<Config> getMapper() {
        return this.configMapper;
    }

    public List<Config> selectListByType(int type) {
        JpaCriteria criteria = JpaCriteria.builder().eq("type", (Object)type).eq("appId", (Object)this.getAppId());
        return super.selectList(criteria);
    }

    public List<Config> selectListByParentId(String parentId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("parentId", (Object)parentId).eq("appId", (Object)this.getAppId());
        return super.selectList(criteria);
    }

    public Config selectByKey(String key) {
        JpaCriteria criteria = JpaCriteria.builder().eq("key", (Object)key).eq("appId", (Object)this.getAppId());
        return (Config)((Object)super.select(criteria));
    }

    public Map<String, Config> selectAsMapByKeyList(String appId, List<? extends HasConfigKey> keyList) {
        Object[] keyArray = new String[keyList.size()];
        int index = 0;
        for (HasConfigKey hasConfigKey : keyList) {
            String key = hasConfigKey.getKey();
            keyArray[index++] = key;
        }
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.in("key", keyArray);
        List list = this.configMapper.selectList(criteria);
        HashMap<String, Config> map = new HashMap<String, Config>();
        if (Checker.listNotEmpty((List)list)) {
            for (Config config : list) {
                map.put(config.getKey(), config);
            }
        }
        return map;
    }

    public Config create(int type, String key, String name, String value, String parentId, int showType, String showValue, short seqNum, boolean show) {
        return this.create(this.getAppId(), type, key, name, value, parentId, showType, showValue, seqNum, show);
    }

    public Config create(String appId, int type, String key, String name, String value, String parentId, int showType, String showValue, short seqNum, boolean show) {
        Config c = new Config();
        BaseDomainUtil.initBaseDomain((BaseDomain)c);
        c.setAppId(appId);
        c.setType(type);
        c.setKey(key);
        c.setName(name);
        c.setValue(value);
        c.setParentId(parentId);
        c.setShowType(showType);
        c.setShowValue(showValue);
        c.setSeqNum(seqNum);
        c.setIsShow(show);
        c.setIsDeleted(false);
        return c;
    }

    public void init(String appId) {
        this.init(appId, "2_4_5_7_10_0_31");
    }

    public int init(String appId, String type) {
        Config c;
        int num = 0;
        LinkedList<Config> list = new LinkedList<Config>();
        if (StringUtils.contains((CharSequence)type, (CharSequence)"0")) {
            c = this.create(appId, 0, ConfigEnum.open_register.name(), "\u662f\u5426\u5f00\u653e\u6ce8\u518c", "1", null, 1, null, (short)10, true);
            Config c1 = this.create(appId, 0, ConfigEnum.is_need_audit.name(), "\u662f\u5426\u9700\u8981\u8ba4\u8bc1", "0", null, 1, null, (short)10, true);
            Config defaultHeadImg = this.create(appId, 0, ConfigEnum.default_headImg.name(), "\u9ed8\u8ba4\u5934\u50cf", "", null, 1, null, (short)10, true);
            list.add(c);
            list.add(c1);
            list.add(defaultHeadImg);
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"2")) {
            c = this.create(appId, 2, "score_money_rate", "\u79ef\u5206\u4e0e\u91d1\u989d\u7684\u5151\u6362\u6bd4\u7387", "100", null, 1, null, (short)10, true);
            list.add(c);
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"4")) {
            c = this.create(appId, 4, "calendar_config", "\u65e5\u7a0b\u63d0\u9192\u914d\u7f6e", "20_9:00_21:00", null, 3, "0_1", (short)10, true);
            list.add(c);
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"7")) {
            Config c1 = this.create(appId, 7, "activity_sign_success", "\u6d3b\u52a8\u62a5\u540d\u6210\u529f\u8bbe\u7f6e", "/attachments/activity/31f76e5ab8f64c229a9f4e75409b25d9.png,", null, 1, null, (short)10, true);
            Config c2 = this.create(appId, 7, "activity_order_type", "\u79fb\u52a8\u7aef\u6d3b\u52a8\u6392\u5e8f\u65b9\u5f0f", "0", null, 1, null, (short)10, true);
            Config c3 = this.create(appId, 7, "activity_sign_subscribe_id", "\u6d3b\u52a8\u62a5\u540d\u6210\u529f\u5c0f\u7a0b\u5e8f\u6a21\u677fid", "VRMxUZt9vCzopHUBnmXZq8d_S412w1vy7oiDhOf7lhk", null, 1, null, (short)10, true);
            list.add(c1);
            list.add(c2);
            list.add(c3);
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"10")) {
            Config auditSwitch = this.create(appId, 10, "audit_switch", "\u8d44\u8baf\u53d1\u5e03\u662f\u5426\u9700\u8981\u5ba1\u6838", "open", null, 1, "\u8d44\u8baf\u53d1\u5e03\u662f\u5426\u9700\u8981\u5ba1\u6838", (short)1, true);
            Config hotCity = this.create(appId, 10, "hot_city", "\u70ed\u95e8\u57ce\u5e02", "\u5317\u4eac_\u5e7f\u5dde_\u6df1\u5733_\u4e0a\u6d77_\u73e0\u6d77_\u4e1c\u839e_\u4f5b\u5c71_\u987a\u5fb7_\u6210\u90fd_\u91cd\u5e86", null, 1, "\u70ed\u95e8\u57ce\u5e02", (short)1, true);
            Config profession = this.create(appId, 10, "profession", "\u4e13\u4e1a\u8bbe\u7f6e", "\u7ecf\u6d4e\u5b66_\u91d1\u878d\u5b66_\u8d22\u653f\u5b66_\u56fd\u8d38_\u7269\u6d41\u7ba1\u7406_\u8ba1\u7b97\u673a_\u4fdd\u9669\u5b66", null, 1, "\u4e13\u4e1a\u8bbe\u7f6e", (short)1, true);
            Config privilege = this.create(appId, 10, "privilege", "\u4f1a\u5458\u7279\u6743\u6587\u5b57\u8bbe\u7f6e", "", null, 1, "\u4f1a\u5458\u7279\u6743\u6587\u5b57\u8bbe\u7f6e", (short)1, true);
            Config heatRate = this.create(appId, 10, "heat_rate", "\u4fe1\u606f\u70ed\u5ea6\u5206\u503c\u914d\u7f6e", "6_1_1_1", null, 1, "\u70b9\u8d5e\u5206\u6570_\u9605\u8bfb\u5206\u6570_\u7559\u8a00\u5206\u6570_\u5206\u4eab\u5206\u6570", (short)1, true);
            Config trade = this.create(appId, 10, "trade", "\u884c\u4e1a\u8bbe\u7f6e", "\u4e92\u8054\u7f51/\u7535\u5b50\u5546\u52a1/\u6e38\u620f_\u5feb\u901f\u6d88\u8d39\u54c1(\u98df\u54c1\u996e\u6599\u5316\u5986\u54c1\u7b49)_\u9910\u996e/\u5a31\u4e50/\u751f\u6d3b\u670d\u52a1_\u57f9\u8bad/\u6559\u80b2/\u9662\u6821_\u653f\u5e9c/\u516c\u5171\u4e8b\u4e1a_\u91d1\u878d/\u6295\u8d44/\u8bc1\u5238/\u8d22\u52a1/\u4fdd\u9669_\u8d38\u6613/\u8fdb\u51fa\u53e3_\u5f71\u89c6/\u5a92\u4f53/\u51fa\u7248/\u6587\u5316\u4f20\u64ad_\u9152\u5e97/\u65c5\u6e38/\u8d85\u5e02/\u7269\u4e1a_\u901a\u4fe1/\u7535\u4fe1/\u8ba1\u7b97\u673a\u670d\u52a1/\u7535\u5b50\u7535\u6c14_\u7f8e\u5bb9/\u4fdd\u5065/\u533b\u836f/\u533b\u7597_\u54a8\u8be2/\u670d\u52a1/\u5e7f\u544a/\u516c\u5173_\u751f\u4ea7\u5236\u9020/\u5316\u5de5/\u91cd\u5de5/\u539f\u6599_\u623f\u5730\u4ea7/\u5efa\u7b51\u5efa\u6750/\u5bb6\u88c5/\u8bbe\u8ba1_\u4ea4\u901a/\u7269\u6d41/\u8fd0\u8f93_\u73af\u4fdd/\u6148\u5584/\u975e\u76c8\u5229\u673a\u6784_\u519c\u6797\u7267\u6e14/\u7535\u529b/\u70df\u8349_\u6cd5\u5f8b/\u68c0\u6d4b/\u8ba4\u8bc1_\u8010\u7528\u6d88\u8d39\u54c1(\u978b\u670d\u7535\u5668\u5bb6\u5177\u7b49)_\u827a\u672f/\u5962\u4f88/\u6536\u85cf_\u5176\u4ed6", null, 1, "\u884c\u4e1a\u8bbe\u7f6e", (short)1, true);
            Config beReportUpperLimit = this.create(appId, 10, "be_report_upper_limit", "\u88ab\u4e3e\u62a5\u591a\u5c11\u6b21\u540e\u4e0b\u67b6", "10", null, 1, "\u88ab\u4e3e\u62a5\u591a\u5c11\u6b21\u540e\u4e0b\u67b6", (short)1, true);
            Config contactsSerialNumber = this.create(appId, 10, "contacts_serial_number", "\u662f\u5426\u5f00\u542f\u6821\u53cb\u7f16\u53f7\u751f\u6210", "open", null, 1, "\u662f\u5426\u5f00\u542f\u6821\u53cb\u7f16\u53f7\u751f\u6210", (short)1, true);
            Config reportOptions = this.create(appId, 10, "report_options", "\u4e3e\u62a5\u9009\u9879", "\u4e0d\u5b9e\u4fe1\u606f_\u8fdd\u53cd\u6cd5\u5f8b\u6cd5\u89c4\u4fe1\u606f_\u8272\u60c5\u66b4\u529b_\u5783\u573e\u8425\u9500_\u8fb1\u9a82", null, 1, "\u4e3e\u62a5\u9009\u9879", (short)1, true);
            Config verificationCodeMsgConfig = this.create(appId, 10, "verification_code_msg_config", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u914d\u7f6e", "1400078371_c37ef2bdb7ebe7a2283e8acbd4befff1_254300_5", null, 1, "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u914d\u7f6e\uff1asdkAppId_appKey_templateId_validMinutes(appId_\u5bc6\u94a5_\u6a21\u677fid_\u6709\u6548\u65f6\u95f4(\u5206))", (short)1, true);
            Config informationType = this.create(appId, 10, "information_type", "\u8d44\u8baf\u53d1\u5e03\u7c7b\u578b", "\u56fe\u6587:1_\u6d3b\u52a8:2", null, 1, "\u8d44\u8baf\u53d1\u5e03\u7c7b\u578b", (short)1, true);
            Config releaseByCowebs = this.create(appId, 10, "RELEASE_BY_COWEBS", "\u662f\u5426\u901a\u8fc7cowebs\u53d1\u5e03", "1", null, 1, "\u662f\u5426\u901a\u8fc7cowebs\u53d1\u5e03\u8d44\u8baf(1--\u8df3\u8f6c\uff0c2--\u4e0d\u8df3\u8f6c)", (short)1, true);
            Config informationPageTitle = this.create(appId, 10, "INFORMATION_PAGE_TITLE", "\u8d44\u8baf\u63a5\u9f99\u9875\u9762\u6807\u9898", "\u8d44\u8baf\u63a5\u9f99", null, 1, "\u8d44\u8baf\u63a5\u9f99\u9875\u9762\u6807\u9898", (short)1, true);
            list.add(informationType);
            list.add(auditSwitch);
            list.add(hotCity);
            list.add(profession);
            list.add(privilege);
            list.add(heatRate);
            list.add(trade);
            list.add(beReportUpperLimit);
            list.add(contactsSerialNumber);
            list.add(reportOptions);
            list.add(verificationCodeMsgConfig);
            list.add(releaseByCowebs);
            list.add(informationPageTitle);
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"5")) {
            Config bbsViewScope = this.create(appId, 5, "bbs_view_scope", "\u8bba\u575b\u67e5\u770b\u6743\u9650", "all", null, 1, "\u8bba\u575b\u67e5\u770b\u6743\u9650\uff1aall-->\u6240\u6709\u4eba\uff1bauth-->\u8ba4\u8bc1\u4f1a\u5458", (short)1, true);
            Config bbsPraiseScope = this.create(appId, 5, "bbs_praise_scope", "\u6587\u7ae0\u70b9\u8d5e\u6743\u9650", "all", null, 1, "\u6587\u7ae0\u70b9\u8d5e\u6743\u9650\uff1aall-->\u6240\u6709\u4eba\uff1bauth-->\u8ba4\u8bc1\u4f1a\u5458", (short)1, true);
            Config bbsCommentScope = this.create(appId, 5, "bbs_comment_scope", "\u6587\u7ae0\u8bc4\u8bba\u6743\u9650", "all", null, 1, "\u6587\u7ae0\u8bc4\u8bba\u6743\u9650\uff1aall-->\u6240\u6709\u4eba\uff1bauth-->\u8ba4\u8bc1\u4f1a\u5458", (short)1, true);
            Config bbsReleaseScope = this.create(appId, 5, "bbs_release_scope", "\u53d1\u5e03\u6587\u7ae0\u6743\u9650", "all", null, 1, "all-->\u6240\u6709\u4eba\uff1bauth-->\u8ba4\u8bc1\u4f1a\u5458", (short)1, true);
            list.add(bbsViewScope);
            list.add(bbsPraiseScope);
            list.add(bbsCommentScope);
            list.add(bbsReleaseScope);
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"31")) {
            Config momentsName = this.create(appId, ConfigTypeEnum.CROP_FRIEND.getIndex(), "moments_name", "\u5c5e\u6027\u540d\u79f0", "\u52a8\u6001\u5708", null, 1, null, (short)1, true);
            Config momentsLinkTitle = this.create(appId, ConfigTypeEnum.CROP_FRIEND.getIndex(), "moments_link_title", "\u52a8\u6001\u5708\u94fe\u63a5\u6807\u9898", "\u67e5\u770b\u8be6\u60c5", null, 1, null, (short)1, true);
            Config friendCancelNotice = this.create(appId, ConfigTypeEnum.CROP_FRIEND.getIndex(), "friend_cancel_notice", "\u88ab\u5220\u9664\u63d0\u9192", "0", null, 1, null, (short)1, true);
            Config sendBusinessCard = this.create(appId, ConfigTypeEnum.CROP_FRIEND.getIndex(), "send_business_card", "\u53d1\u9001\u540d\u7247\u5c0f\u7a0b\u5e8f", "0", null, 1, null, (short)1, true);
            list.add(momentsName);
            list.add(momentsLinkTitle);
            list.add(friendCancelNotice);
            list.add(sendBusinessCard);
        }
        for (Config c2 : list) {
            Config tmp = this.selectByKey(c2.getKey(), appId);
            if (tmp != null) continue;
            this.insert((Object)c2);
            ++num;
        }
        return num;
    }

    public Config getByKey(String key) {
        return this.selectByKey(key, this.getAppId());
    }

    public Config selectByKey(String key, String appId) {
        return (Config)((Object)super.select(JpaCriteria.builder().eq("key", (Object)key).eq("appId", (Object)appId)));
    }

    public Config getCache(String key, String appId) {
        Config config = (Config)((Object)this.simpleRedisTemplate.get(this.getCacheKey(appId, key), Config.class));
        if (config == null && (config = this.selectByKey(key, appId)) != null) {
            this.setCache(config);
        }
        return config;
    }

    public void setCache(Config config) {
        this.simpleRedisTemplate.set(this.getCacheKey(config.getAppId(), config.getKey()), (Object)config);
    }

    public void removeCache(Config config) {
        this.simpleRedisTemplate.delete(new String[]{this.getCacheKey(config.getAppId(), config.getKey())});
    }

    private String getCacheKey(String appId, String key) {
        return "config_" + appId + key;
    }

    public void invoking() {
        List list = this.configMapper.selectList(JpaCriteria.builder().eq("isDeleted", (Object)false));
        for (Config config : list) {
            this.setCache(config);
        }
    }

    public void copyData(String sourceAppId, String targetAppId) {
        LinkedList<Config> list = this.configMapper.selectList(JpaCriteria.builder().eq("appId", (Object)sourceAppId).eq("isDeleted", (Object)false));
        List oldList = this.configMapper.selectList(JpaCriteria.builder().eq("appId", (Object)targetAppId).eq("isDeleted", (Object)false));
        if (!oldList.isEmpty()) {
            HashSet<String> codeSet = new HashSet<String>();
            for (Config c : oldList) {
                codeSet.add(c.getKey());
            }
            LinkedList<Config> addList = new LinkedList<Config>();
            for (Config c : list) {
                if (codeSet.contains(c.getKey())) continue;
                addList.add(c);
            }
            list = addList;
        }
        if (!list.isEmpty()) {
            AppCopyUtil.copyData((List)list, (String)targetAppId);
            this.configMapper.insertBatch(list);
        }
        log.error("\u5171\u590d\u5236{}\u884cConfig\u6570\u636e", (Object)list.size());
    }
}

