/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.github.tobato.fastdfs.domain.conn.FdfsConnectionManager;
import com.github.tobato.fastdfs.domain.fdfs.StorageNode;
import com.github.tobato.fastdfs.domain.fdfs.StorePath;
import com.github.tobato.fastdfs.domain.proto.FdfsCommand;
import com.github.tobato.fastdfs.domain.proto.storage.StorageUploadFileCommand;
import com.github.tobato.fastdfs.service.TrackerClient;
import com.wego168.base.config.FastDfsStorageConfig;
import com.wego168.base.model.response.FileUploadResponse;
import com.wego168.base.service.facade.IStorageService;
import com.wego168.base.util.FileUtil;
import com.wego168.exception.HttpException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDfsStorageService
implements IStorageService {
    private static final Logger log = LoggerFactory.getLogger(FastDfsStorageService.class);
    TrackerClient trackerClient;
    FdfsConnectionManager fdfsConnectionManager;
    String host;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(TrackerClient trackerClient, FdfsConnectionManager fdfsConnectionManager, FastDfsStorageConfig config) {
        if (trackerClient == null || fdfsConnectionManager == null || config == null) return;
        Class<FastDfsStorageService> clazz = FastDfsStorageService.class;
        synchronized (FastDfsStorageService.class) {
            if (trackerClient == null || fdfsConnectionManager == null || config == null) return;
            this.trackerClient = trackerClient;
            this.fdfsConnectionManager = fdfsConnectionManager;
            this.host = config.getHost();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public FileUploadResponse simplePut(String fileName, InputStream in) {
        return this.put(null, fileName, in, null);
    }

    @Override
    public FileUploadResponse simplePut(String filePathAndName, byte[] bytes) {
        return this.put(null, filePathAndName, bytes, null);
    }

    @Override
    public FileUploadResponse simplePut(String filePathAndName, File localFile) {
        return this.put(null, filePathAndName, localFile, null);
    }

    @Override
    public FileUploadResponse put(String bucket, String fileName, InputStream in, Map<String, String> metaData) {
        bucket = "group1";
        long fileSize = 0L;
        try {
            fileSize = in.available();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String fileSubfix = FileUtil.getFileSubfixWithoutDot(fileName);
        StorageNode client = this.trackerClient.getStoreStorage(bucket);
        StorageUploadFileCommand command = new StorageUploadFileCommand(client.getStoreIndex(), in, fileSubfix, fileSize, true);
        StorePath storePath = (StorePath)this.fdfsConnectionManager.executeFdfsCmd(client.getInetSocketAddress(), (FdfsCommand)command);
        FileUploadResponse response = new FileUploadResponse();
        response.setSize(fileSize);
        response.setUrl("/" + storePath.getFullPath());
        response.setHost(this.host);
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUploadResponse put(String bucket, String filePathAndName, byte[] bytes, Map<String, String> metaData) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            FileUploadResponse fileUploadResponse = this.put(bucket, filePathAndName, in, metaData);
            return fileUploadResponse;
        }
        catch (IOException e) {
            log.error("fastfds\u4e0a\u4f20\u5173\u95ed\u5b57\u8282\u6d41\u5931\u8d25");
            throw HttpException.writeError();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUploadResponse put(String bucket, String filePathAndName, File localFile, Map<String, String> metaData) {
        try (FileInputStream in = new FileInputStream(localFile);){
            FileUploadResponse fileUploadResponse = this.put(bucket, filePathAndName, in, metaData);
            return fileUploadResponse;
        }
        catch (IOException e) {
            log.error("fastfds\u4e0a\u4f20\u5173\u95ed\u5b57\u8282\u6d41\u5931\u8d25");
            throw HttpException.writeError();
        }
    }
}

