/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.wego168.base.domain.FileServer;
import com.wego168.base.persistence.FileServerMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileServerService
extends CrudService<FileServer> {
    @Autowired
    private FileServerMapper fileServerMapper;

    public CrudMapper<FileServer> getMapper() {
        return this.fileServerMapper;
    }

    public Map<String, FileServer> selectMapByIdSet(Set<String> idSet) {
        List<FileServer> list = this.fileServerMapper.selectListByIdSet(idSet);
        if (list != null && list.size() > 0) {
            HashMap<String, FileServer> map = new HashMap<String, FileServer>();
            for (FileServer server : list) {
                map.put(server.getId(), server);
            }
            return map;
        }
        return null;
    }

    public FileServer ensure() {
        String defaultServerId = "1";
        return this.ensure(defaultServerId);
    }

    private FileServer ensure(String id) {
        FileServer server = (FileServer)this.fileServerMapper.selectById(id);
        Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e");
        return server;
    }
}

