/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.LevelConfig;
import com.wego168.base.persistence.LevelConfigMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.web.AuthenticationUser;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LevelConfigService
extends BaseService<LevelConfig> {
    @Autowired
    protected AuthenticationUser authenticationUser;
    @Autowired
    private LevelConfigMapper levelConfigMapper;

    public CrudMapper<LevelConfig> getMapper() {
        return this.levelConfigMapper;
    }

    public LevelConfig create(int type, int level, int experienceAmount, String name, String icon, String description, String appId) {
        LevelConfig config = new LevelConfig();
        BaseDomainUtil.initBaseDomain((BaseDomain)config);
        config.setAppId(appId);
        config.setExperienceAmount(experienceAmount);
        config.setDescription(description);
        config.setIcon(icon);
        config.setLevel(level);
        config.setName(name);
        config.setType(type);
        return config;
    }

    public int update(int level, int experienceAmount, String name, String icon, String description, String id) {
        LevelConfig config = new LevelConfig();
        config.setExperienceAmount(experienceAmount);
        config.setDescription(description);
        config.setIcon(icon);
        config.setLevel(level);
        config.setName(name);
        config.setUpdateTime(new Date());
        config.setId(id);
        return this.levelConfigMapper.updateSelective((Object)config);
    }

    public List<LevelConfig> selectList(Page page) {
        page.eq("appId", (Object)this.authenticationUser.getAppId()).eq("type", page.get((Object)"type")).orderBy("level asc");
        return super.selectPage(page);
    }

    public LevelConfig selectByLevel(int level, int type) {
        return (LevelConfig)((Object)this.levelConfigMapper.select(JpaCriteria.builder().eq("level", (Object)level).eq("type", (Object)type).eq("appId", (Object)this.authenticationUser.getAppId())));
    }

    public LevelConfig selectMinLevel(int type, String appId) {
        Page page = new Page();
        page.setCount(false);
        page.setPageNum(1);
        page.setPageSize(1);
        page.eq("type", (Object)type).eq("appId", (Object)appId).orderBy("level asc");
        List list = this.levelConfigMapper.selectPage(page);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (LevelConfig)((Object)list.get(0));
    }

    public LevelConfig selectUpperLevel(int type, int currentLevel, String appId) {
        Page page = new Page();
        page.setCount(false);
        page.setPageNum(1);
        page.setPageSize(1);
        page.eq("type", (Object)type).eq("appId", (Object)appId).gt("level", (Object)currentLevel).orderBy("level asc");
        List list = this.levelConfigMapper.selectPage(page);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (LevelConfig)((Object)list.get(0));
    }
}

