/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Level;
import com.wego168.base.domain.LevelConfig;
import com.wego168.base.domain.LevelExperience;
import com.wego168.base.domain.LevelExperienceSource;
import com.wego168.base.enums.MaxTypeEnum;
import com.wego168.base.persistence.LevelExperienceMapper;
import com.wego168.base.service.LevelConfigService;
import com.wego168.base.service.LevelService;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LevelExperienceService
extends BaseService<LevelExperience> {
    @Autowired
    private LevelExperienceMapper levelExperienceMapper;
    @Autowired
    private LevelService levelService;
    @Autowired
    private LevelConfigService levelConfigService;

    public CrudMapper<LevelExperience> getMapper() {
        return this.levelExperienceMapper;
    }

    @Transactional
    public boolean addExperience(int amount, int type, String memberId, String fromId, String source, String description, String note, String appId) {
        Level memberLevel = this.levelService.selectByType(memberId, type, appId);
        int currentExp = memberLevel.getExperienceAmount();
        int currentLevel = memberLevel.getLevel();
        String levelId = memberLevel.getId();
        LevelExperience experience = new LevelExperience();
        BaseDomainUtil.initBaseDomain((BaseDomain)experience);
        experience.setAppId(appId);
        experience.setAmount(amount);
        experience.setDescription(description);
        experience.setFromId(fromId);
        experience.setType(type);
        experience.setMemberId(memberId);
        experience.setNote(note);
        experience.setSource(source);
        int afterAddExp = currentExp + amount;
        experience.setExperienceAmount(afterAddExp);
        this.levelExperienceMapper.insert((Object)experience);
        LevelConfig nextLevel = this.levelConfigService.selectUpperLevel(type, currentLevel, appId);
        if (nextLevel == null) {
            this.levelService.updateExpOnly(afterAddExp, levelId);
            return false;
        }
        int nextLevelExp = nextLevel.getExperienceAmount();
        if (afterAddExp >= nextLevelExp) {
            this.levelService.upgradeLevel(nextLevel, afterAddExp, levelId);
            return true;
        }
        this.levelService.updateExpOnly(afterAddExp, levelId);
        return false;
    }

    public boolean addExperienceBySource(String memberId, String fromId, LevelExperienceSource source, String note) {
        int todayExperience;
        int count;
        int maxPerDay;
        Integer maxType = source.getMaxType();
        if (maxType == MaxTypeEnum.MAX_TIMES.getIndex() ? (maxPerDay = source.getMaxPerDay().intValue()) > 0 && (count = this.countExperienceBySourceInToday(source.getCode(), memberId)) >= maxPerDay : (maxPerDay = source.getMaxPerDay().intValue()) > 0 && (todayExperience = this.sumExperienceBySourceInToday(source.getCode(), memberId)) >= maxPerDay) {
            return false;
        }
        return this.addExperience(source.getAmount(), source.getType(), memberId, fromId, source.getCode(), source.getDescription(), note, source.getAppId());
    }

    @Deprecated
    public LevelExperience selectLatestOne(String memberId, int type) {
        Page page = new Page();
        page.setCount(false);
        page.setPageNum(1);
        page.setPageSize(1);
        page.eq("memberId", (Object)memberId).eq("type", (Object)type).orderBy("createTime desc");
        List list = this.levelExperienceMapper.selectPage(page);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (LevelExperience)((Object)list.get(0));
    }

    public int selectCountBySource(String memberId, String sourceCode, String fromId, int type, String appId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("memberId", (Object)memberId).eq("source", (Object)sourceCode).eq("type", (Object)type).eq("fromId", (Object)fromId).eq("appId", (Object)appId);
        return this.levelExperienceMapper.selectCount(criteria);
    }

    public int sumExperienceBySourceInToday(String sourceCode, String memberId) {
        Date tomorrow0Clock;
        Date today0Clock = DateUtil.getToday0oClock();
        Integer sum = this.levelExperienceMapper.sumExperienceBySourceInToday(sourceCode, memberId, today0Clock, tomorrow0Clock = DateUtil.addDaysToDate((Date)today0Clock, (int)1));
        return sum == null ? 0 : sum;
    }

    public int countExperienceBySourceInToday(String sourceCode, String memberId) {
        Date tomorrow0Clock;
        Date today0Clock = DateUtil.getToday0oClock();
        Integer count = this.levelExperienceMapper.countExperienceBySourceInToday(sourceCode, memberId, today0Clock, tomorrow0Clock = DateUtil.addDaysToDate((Date)today0Clock, (int)1));
        return count == null ? 0 : count;
    }

    @Deprecated
    public int selectTotalExperience(String memberId, int levelType) {
        LevelExperience levelExperience = this.selectLatestOne(memberId, levelType);
        return levelExperience == null ? 0 : levelExperience.getExperienceAmount();
    }
}

