/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.LevelExperienceSource;
import com.wego168.base.persistence.LevelExperienceSourceMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LevelExperienceSourceService
extends BaseService<LevelExperienceSource> {
    @Autowired
    private LevelExperienceSourceMapper levelExperienceSourceMapper;

    public CrudMapper<LevelExperienceSource> getMapper() {
        return this.levelExperienceSourceMapper;
    }

    public LevelExperienceSource create(int amount, int type, int maxPerDay, String name, String code, String description, String note, String appId) {
        LevelExperienceSource source = new LevelExperienceSource();
        BaseDomainUtil.initBaseDomain((BaseDomain)source);
        source.setAppId(appId);
        source.setAmount(amount);
        source.setCode(code);
        source.setDescription(description);
        source.setType(type);
        source.setMaxPerDay(maxPerDay);
        source.setName(name);
        source.setNote(note);
        return source;
    }

    public int deleteById(Object id) {
        LevelExperienceSource source = new LevelExperienceSource();
        source.setIsDeleted(true);
        source.setId(id.toString());
        return this.levelExperienceSourceMapper.updateSelective((Object)source);
    }

    public int update(int amount, int maxPerDay, String description, String name, String note, String id) {
        LevelExperienceSource source = new LevelExperienceSource();
        source.setAmount(amount);
        source.setDescription(description);
        source.setMaxPerDay(maxPerDay);
        source.setName(name);
        source.setNote(note);
        source.setUpdateTime(new Date());
        source.setId(id);
        return this.levelExperienceSourceMapper.updateSelective((Object)source);
    }

    public List<LevelExperienceSource> selectList(int type, String appId, Page page) {
        page.eq("appId", (Object)appId).eq("type", (Object)type);
        page.orderBy("amount asc");
        return super.selectPage(page);
    }

    public LevelExperienceSource selectByCode(int type, String code, String appId) {
        return (LevelExperienceSource)((Object)this.levelExperienceSourceMapper.select(JpaCriteria.builder().eq("type", (Object)type).eq("code", (Object)code).eq("appId", (Object)appId)));
    }
}

