/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Level;
import com.wego168.base.domain.LevelConfig;
import com.wego168.base.domain.LevelRank;
import com.wego168.base.persistence.LevelMapper;
import com.wego168.base.service.LevelConfigService;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.web.AuthenticationUser;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LevelService
extends BaseService<Level> {
    @Autowired
    private LevelMapper levelMapper;
    @Autowired
    private LevelConfigService levelConfigService;
    @Autowired
    protected AuthenticationUser authenticationUser;

    public CrudMapper<Level> getMapper() {
        return this.levelMapper;
    }

    private Level createMemberLevel(LevelConfig config, String memberId, String appId) {
        Level memberLevel = new Level();
        BaseDomainUtil.initBaseDomain((BaseDomain)memberLevel);
        memberLevel.setAppId(appId);
        memberLevel.setDescription(config.getDescription());
        memberLevel.setExperienceAmount(config.getExperienceAmount());
        memberLevel.setIcon(config.getIcon());
        memberLevel.setLevel(config.getLevel());
        memberLevel.setName(config.getName());
        memberLevel.setOwnerId(memberId);
        memberLevel.setType(config.getType());
        return memberLevel;
    }

    public int updateExpOnly(int exp, String id) {
        Level memberLevel = new Level();
        memberLevel.setExperienceAmount(exp);
        memberLevel.setUpdateTime(new Date());
        memberLevel.setId(id);
        return this.levelMapper.updateSelective((Object)memberLevel);
    }

    public int upgradeLevel(LevelConfig nextLevel, int exp, String id) {
        Level memberLevel = new Level();
        memberLevel.setDescription(nextLevel.getDescription());
        memberLevel.setExperienceAmount(exp);
        memberLevel.setIcon(nextLevel.getIcon());
        memberLevel.setLevel(nextLevel.getLevel());
        memberLevel.setName(nextLevel.getName());
        memberLevel.setUpdateTime(new Date());
        memberLevel.setId(id);
        return this.levelMapper.updateSelective((Object)memberLevel);
    }

    public Level selectByType(String memberId, int type, String appId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("ownerId", (Object)memberId).eq("type", (Object)type);
        Level level = (Level)((Object)this.levelMapper.select(criteria));
        if (level == null) {
            LevelConfig config = this.levelConfigService.selectMinLevel(type, appId);
            if (config == null) {
                config = this.levelConfigService.create(type, 0, 0, "\u65b0\u624b", null, "\u7cfb\u7edf\u521b\u5efa", appId);
            }
            level = this.createMemberLevel(config, memberId, appId);
            this.levelMapper.insert((Object)level);
        }
        return level;
    }

    public List<LevelRank> selectRank(int type, int rankSize, String appId) {
        return this.levelMapper.selectRank(type, rankSize, appId);
    }
}

