/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.wego168.base.domain.MultiContent;
import com.wego168.base.domain.MultiContentSingleContent;
import com.wego168.base.domain.SingleContent;
import com.wego168.base.persistence.MultiContentMapper;
import com.wego168.base.persistence.MultiContentSingleContentMapper;
import com.wego168.base.service.SingleContentService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.web.util.GuidGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MultiContentService
extends BaseService<MultiContent> {
    @Autowired
    private MultiContentMapper multiContentMapper;
    @Autowired
    private MultiContentSingleContentMapper multiContentSingleContentMapper;
    @Autowired
    private SingleContentService singleContentService;

    public CrudMapper<MultiContent> getMapper() {
        return this.multiContentMapper;
    }

    @Transactional
    public int insert(MultiContent multiContent) {
        List<SingleContent> singleContentList = multiContent.getSingleContentList();
        if (StringUtils.isBlank((CharSequence)multiContent.getId())) {
            multiContent.setId(GuidGenerator.generate());
            multiContent.setCreateTime(new Date());
            this.multiContentMapper.insert((Object)multiContent);
            for (int i = 0; i < singleContentList.size(); ++i) {
                SingleContent singleContent = singleContentList.get(i);
                this.singleContentService.insert(singleContent);
                MultiContentSingleContent multiContentSingleContent = this.createRelate(multiContent.getId(), singleContent.getId(), i);
                this.multiContentSingleContentMapper.insert(multiContentSingleContent);
            }
        } else {
            multiContent.setUpdateTime(new Date());
            this.multiContentMapper.update((Object)multiContent);
            List<MultiContentSingleContent> relateList = this.multiContentSingleContentMapper.selectByOrder(multiContent.getId());
            HashMap<String, SingleContent> singleMap = new HashMap<String, SingleContent>();
            for (MultiContentSingleContent multiContentSingleContent : relateList) {
                SingleContent singleContent = this.singleContentService.get(multiContentSingleContent.getSingleContentId());
                singleMap.put(singleContent.getId(), singleContent);
            }
            this.multiContentSingleContentMapper.deleteByMultiContentId(multiContent.getId());
            for (int i = 0; i < singleContentList.size(); ++i) {
                SingleContent singleContent = singleContentList.get(i);
                if (singleMap.containsKey(singleContent.getId())) {
                    this.singleContentService.update(singleContent);
                    singleMap.remove(singleContent.getId());
                } else {
                    this.singleContentService.insert(singleContent);
                }
                MultiContentSingleContent multiContentSingleContent = this.createRelate(multiContent.getId(), singleContent.getId(), i);
                this.multiContentSingleContentMapper.insert(multiContentSingleContent);
            }
            for (String removeId : singleMap.keySet()) {
                this.singleContentService.deleteById(removeId);
            }
        }
        return 1;
    }

    public MultiContentSingleContent createRelate(String multiContentId, String singleContentId, int i) {
        MultiContentSingleContent multiContentSingleContent = new MultiContentSingleContent();
        multiContentSingleContent.setId(GuidGenerator.generate());
        multiContentSingleContent.setMultiContentId(multiContentId);
        multiContentSingleContent.setSingleContentId(singleContentId);
        multiContentSingleContent.setSeqNum(i + 1);
        multiContentSingleContent.setCreateTime(new Date());
        return multiContentSingleContent;
    }

    public MultiContent get(String id) {
        MultiContent multiContent = (MultiContent)((Object)this.multiContentMapper.selectById(id));
        List<MultiContentSingleContent> list = this.multiContentSingleContentMapper.selectByOrder(id);
        ArrayList<SingleContent> singleContentList = new ArrayList<SingleContent>();
        for (MultiContentSingleContent multiContentSingleContent : list) {
            SingleContent singleContent = this.singleContentService.get(multiContentSingleContent.getSingleContentId());
            singleContentList.add(singleContent);
        }
        multiContent.setSingleContentList(singleContentList);
        return multiContent;
    }

    @Transactional
    public void delete(String id) {
        super.deleteById((Object)id);
        List<MultiContentSingleContent> list = this.multiContentSingleContentMapper.selectByOrder(id);
        for (MultiContentSingleContent multiContentSingleContent : list) {
            this.singleContentService.deleteById(multiContentSingleContent.getSingleContentId());
        }
        this.multiContentSingleContentMapper.deleteByMultiContentId(id);
    }
}

