/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.base.domain.PartakeSense;
import com.wego168.base.domain.ReviewSummary;
import com.wego168.base.domain.ShortSentence;
import com.wego168.base.persistence.PartakeSenseMapper;
import com.wego168.base.service.ReviewSummaryService;
import com.wego168.base.service.ShortSentenceService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PartakeSenseService
extends BaseService<PartakeSense> {
    @Autowired
    private PartakeSenseMapper partakeSenseMapper;
    @Autowired
    private ShortSentenceService shortSentenceService;
    @Autowired
    private ReviewSummaryService reviewSummaryService;

    public CrudMapper<PartakeSense> getMapper() {
        return this.partakeSenseMapper;
    }

    public List<PartakeSense> selectPage(Page page) {
        page.eq("sourceId").eq("memberId").orderBy("create_time desc");
        return super.selectPage(page);
    }

    public PartakeSense insertPartakeSense(PartakeSense vo) {
        ShortSentence shortSentence = (ShortSentence)((Object)this.shortSentenceService.selectById(vo.getShortSentenceId()));
        if (shortSentence != null) {
            vo.setShortSentence(shortSentence.getContent());
            shortSentence.setUseNum(shortSentence.getUseNum() + 1);
            this.shortSentenceService.updateSelective((Object)shortSentence);
        }
        super.insert((Object)vo);
        return vo;
    }

    public Map<String, Object> selectPartakeSenseById(String id) {
        PartakeSense vo = this.partakeSenseMapper.selectPartakeSenseByIdWithMemberInfo(id);
        ReviewSummary reviewSummary = this.reviewSummaryService.selectBySourceId(vo.getSourceId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("partakeSense", vo);
        map.put("reviewSummary", (Object)reviewSummary);
        return map;
    }

    public List<Bootmap> listWithMemberInfo(Page page) {
        return this.partakeSenseMapper.listWithMemberInfo(page);
    }
}

