/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.PersonIpObject;
import com.wego168.base.model.response.PersonIpWebListResponse;
import com.wego168.base.persistence.PersonIpObjectMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonIpObjectService
extends BaseService<PersonIpObject> {
    @Autowired
    private PersonIpObjectMapper personIpObjectMapper;

    public CrudMapper<PersonIpObject> getMapper() {
        return this.personIpObjectMapper;
    }

    @Transactional
    public void refresh(List<PersonIpObject> requestPersonIpObjectList) {
        String personIpId = requestPersonIpObjectList.get(0).getPersonIpId();
        this.personIpObjectMapper.delete(JpaCriteria.builder().eq("personIpId", (Object)personIpId));
        this.personIpObjectMapper.insertBatch(requestPersonIpObjectList);
    }

    public void deleteList(List<PersonIpObject> requestPersonIpObjectList) {
        String personIpId = requestPersonIpObjectList.get(0).getPersonIpId();
        this.personIpObjectMapper.deleteList(personIpId, requestPersonIpObjectList);
    }

    public void assembleObjectQuantity(List<PersonIpWebListResponse> list, String objectType) {
        if (list != null && list.size() > 0) {
            ArrayList<String> personIpIdList = new ArrayList<String>(list.size());
            for (PersonIpWebListResponse personIpWebListResponse : list) {
                personIpIdList.add(personIpWebListResponse.getId());
            }
            Map<String, Integer> quantityMap = this.selectObjectCount(personIpIdList, objectType);
            for (PersonIpWebListResponse personIpWebListResponse : list) {
                String personIpId = personIpWebListResponse.getId();
                personIpWebListResponse.setObjectQuantity(quantityMap.get(personIpId));
            }
        }
    }

    private Map<String, Integer> selectObjectCount(List<String> personIpIdList, String objectType) {
        List<Bootmap> quantityList = this.personIpObjectMapper.selectObjectCount(personIpIdList, objectType);
        HashMap<String, Integer> quantityMap = new HashMap<String, Integer>();
        if (quantityList != null && quantityList.size() > 0) {
            for (Bootmap bootmap : quantityList) {
                quantityMap.put(bootmap.getString("personIpId"), bootmap.getInteger("quantity"));
            }
        }
        return quantityMap;
    }
}

