/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Content;
import com.wego168.base.domain.PersonIp;
import com.wego168.base.model.response.PersonIpAdminListResponse;
import com.wego168.base.model.response.PersonIpWebListResponse;
import com.wego168.base.persistence.ContentMapper;
import com.wego168.base.persistence.PersonIpMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonIpService
extends BaseService<PersonIp> {
    @Autowired
    private PersonIpMapper personIpMapper;
    @Autowired
    private ContentMapper contentMapper;

    public CrudMapper<PersonIp> getMapper() {
        return this.personIpMapper;
    }

    public List<PersonIpAdminListResponse> selectPageForAdmin(String name, String appId, Page page) {
        if (StringUtil.isNotBlank((String)name)) {
            page.put((Object)"name", (Object)("%" + name + "%"));
        }
        page.put((Object)"isDeleted", (Object)false);
        page.put((Object)"appId", (Object)appId);
        return this.personIpMapper.selectPageForAdmin(page);
    }

    public List<PersonIpWebListResponse> selectPageForWeb(String appId, Page page) {
        page.put((Object)"isDeleted", (Object)false);
        page.put((Object)"appId", (Object)appId);
        return this.personIpMapper.selectPageForWeb(page);
    }

    @Transactional
    public void insert(String name, String headImage, String content, String introduction, int sortNumber, String appId) {
        PersonIp personIp = new PersonIp();
        BaseDomainUtil.initBaseDomain((BaseDomain)personIp, (String)appId);
        personIp.setName(name);
        personIp.setHeadImage(headImage);
        personIp.setSortNumber(sortNumber);
        personIp.setIntroduction(introduction);
        Content contentDb = new Content();
        contentDb.setAppId(appId);
        contentDb.setContent(content);
        contentDb.setId(SequenceUtil.createUuid());
        personIp.setContentId(contentDb.getId());
        this.personIpMapper.insert((Object)personIp);
        this.contentMapper.insert(contentDb);
    }

    @Transactional
    public void update(String id, String name, String headImage, int sortNumber, String contentId, String content, String introduction) {
        PersonIp personIpParam = new PersonIp();
        personIpParam.setId(id);
        personIpParam.setUpdateTime(new Date());
        personIpParam.setName(name);
        personIpParam.setHeadImage(headImage);
        personIpParam.setSortNumber(sortNumber);
        personIpParam.setIntroduction(introduction);
        this.personIpMapper.updateSelective((Object)personIpParam);
        Content contentParam = new Content();
        contentParam.setId(contentId);
        contentParam.setContent(content);
        this.contentMapper.updateSelective(contentParam);
    }
}

