/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Praisable;
import com.wego168.base.domain.Praise;
import com.wego168.base.persistence.PraiseMapper;
import com.wego168.base.service.callback.Callback;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PraiseService
extends BaseService<Praise> {
    @Autowired
    private PraiseMapper praiseMapper;

    public CrudMapper<Praise> getMapper() {
        return this.praiseMapper;
    }

    public Praise createByOpenId(String openId, String sourceId, int sourceType) {
        Praise praise = new Praise();
        BaseDomainUtil.initBaseDomain((BaseDomain)praise);
        praise.setAppId(this.getAppId());
        praise.setOpenId(openId);
        praise.setSourceId(sourceId);
        praise.setSourceType(sourceType);
        return praise;
    }

    public Praise create(String memberId, String sourceId, int sourceType) {
        return this.create(memberId, sourceId, sourceType, this.getAppId());
    }

    public Praise create(String memberId, String sourceId, int sourceType, String appId) {
        Praise praise = new Praise();
        BaseDomainUtil.initBaseDomain((BaseDomain)praise, (String)appId);
        praise.setMemberId(memberId);
        praise.setSourceId(sourceId);
        praise.setSourceType(sourceType);
        return praise;
    }

    @Transactional
    public void addPraise(Praise praise, Praisable praisable, Callback<Praisable> callback) {
        this.praiseMapper.insert((Object)praise);
        callback.execute(praisable);
    }

    @Transactional
    public void deletePraise(String sourceId, String memberId, Praisable praisable, Callback<Praisable> callback) {
        this.deleteBySourceId(sourceId, memberId);
        callback.execute(praisable);
    }

    @Transactional
    public void deletePraiseByOpenId(String sourceId, String openId, Praisable praisable, Callback<Praisable> callback) {
        this.deleteBySourceIdAndOpenId(sourceId, openId);
        callback.execute(praisable);
    }

    public List<Praise> selectPage(String sourceId, Page page) {
        page.put((Object)"sourceId", (Object)sourceId);
        List<Praise> list = this.praiseMapper.selectPage(page);
        return list;
    }

    public List<Praise> selectBySourceId(String sourceId, String memberId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("sourceId", (Object)sourceId).eq("memberId", (Object)memberId);
        List list = this.praiseMapper.selectList(criteria);
        return list;
    }

    public List<Praise> selectBySourceIdAndOpenId(String sourceId, String openId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("sourceId", (Object)sourceId).eq("openId", (Object)openId);
        List list = this.praiseMapper.selectList(criteria);
        return list;
    }

    public void deleteBySourceId(String sourceId, String memberId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("sourceId", (Object)sourceId).eq("memberId", (Object)memberId);
        this.praiseMapper.delete(criteria);
    }

    public void deleteBySourceIdAndOpenId(String sourceId, String openId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("sourceId", (Object)sourceId).eq("openId", (Object)openId);
        this.praiseMapper.delete(criteria);
    }

    public int updatePraiseQuantity(Praisable praisable) {
        return this.praiseMapper.updateSelective(praisable);
    }

    public int countPraiseQuantity(String sourceId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("sourceId", (Object)sourceId);
        return this.praiseMapper.selectCount(criteria);
    }
}

