/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.Content;
import com.wego168.base.domain.ReviewSummary;
import com.wego168.base.domain.ShortSentence;
import com.wego168.base.persistence.ContentMapper;
import com.wego168.base.persistence.ReviewSummaryMapper;
import com.wego168.base.service.ContentService;
import com.wego168.base.service.ShortSentenceService;
import com.wego168.domain.CosAccess;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.qrcode.QrCodeUtil;
import com.wego168.web.util.GuidGenerator;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReviewSummaryService
extends BaseService<ReviewSummary> {
    @Autowired
    private ContentService contentService;
    @Autowired
    private ShortSentenceService shortSentenceService;
    @Autowired
    private ReviewSummaryMapper reviewSummaryMapper;
    @Autowired
    private ContentMapper contentMapper;

    public CrudMapper<ReviewSummary> getMapper() {
        return this.reviewSummaryMapper;
    }

    public List<ReviewSummary> selectPage(Page page) {
        page.eq("sourceType").orderBy("create_time desc");
        return super.selectPage(page);
    }

    public ReviewSummary selectReviewSummaryById(String id) {
        return this.reviewSummaryMapper.selectReviewSummaryById(id);
    }

    public ReviewSummary selectBySourceId(String sourceId) {
        return this.reviewSummaryMapper.selectReviewSummaryBySourceId(sourceId);
    }

    @Transactional
    public void insertReviewSummary(ReviewSummary vo, String imgPath, CosAccess cosAccess) {
        vo.setId(GuidGenerator.generate());
        vo.setCreateTime(new Date());
        Content content = new Content();
        content.setId(GuidGenerator.generate());
        content.setContent(vo.getContent());
        this.contentService.insert(content);
        vo.setContentId(content.getId());
        System.out.println(vo.getId());
        String fileName = vo.getId() + ".png";
        imgPath = imgPath + fileName;
        String qrcodeUrlString = vo.getQrcodeUrlString() + vo.getSourceId();
        QrCodeUtil.generateQrCode((String)imgPath, (String)qrcodeUrlString, null, (Integer)400, (Integer)400);
        File file = new File(imgPath);
        String formattedPath = FileUploadUtil.upload(file, fileName, "QRCode", cosAccess);
        vo.setQrcodeUrl(formattedPath);
        List<ShortSentence> shortSentenceList = vo.getShortSentenceList();
        if (shortSentenceList != null && shortSentenceList.size() > 0) {
            for (ShortSentence shortSentence : shortSentenceList) {
                shortSentence.setSourceId(vo.getSourceId());
                shortSentence.setSourceType(vo.getSourceType());
                shortSentence.setUseNum(0);
            }
            this.shortSentenceService.insertBatch(shortSentenceList);
        }
        super.insert((Object)vo);
    }

    @Transactional
    public ReviewSummary updateReviewSummary(ReviewSummary oldReviewSummary, ReviewSummary newReviewSummary) {
        List oldList = this.shortSentenceService.selectList(JpaCriteria.builder().eq("sourceId", (Object)oldReviewSummary.getSourceId()));
        List<ShortSentence> newList = newReviewSummary.getShortSentenceList();
        Content content = (Content)this.contentMapper.selectById(oldReviewSummary.getContentId());
        content.setContent(newReviewSummary.getContent());
        this.contentMapper.updateSelective(content);
        this.shortSentenceService.updateList(oldList, newList, oldReviewSummary);
        this.reviewSummaryMapper.updateSelective((Object)newReviewSummary);
        return newReviewSummary;
    }
}

