/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Sharable;
import com.wego168.base.domain.Share;
import com.wego168.base.persistence.ShareMapper;
import com.wego168.base.service.callback.Callback;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShareService
extends BaseService<Share> {
    @Autowired
    private ShareMapper shareMapper;

    public CrudMapper<Share> getMapper() {
        return this.shareMapper;
    }

    public Share create(String memberId, String sourceId, int sourceType, String title, String url, String appId) {
        Share share = new Share();
        BaseDomainUtil.initBaseDomain((BaseDomain)share);
        share.setAppId(appId);
        share.setTitle(title);
        share.setUrl(url);
        share.setMemberId(memberId);
        share.setSourceId(sourceId);
        share.setSourceType(sourceType);
        return share;
    }

    @Transactional
    public void addShare(Share share, Sharable shareable, Callback<Sharable> callback) {
        this.shareMapper.insert((Object)share);
        callback.execute(shareable);
    }

    public List<Share> selectPage(String sourceId, Page page) {
        page.put((Object)"sourceId", (Object)sourceId);
        List<Share> list = this.shareMapper.selectPage(page);
        return list;
    }

    public int updateShareQuantity(Sharable shareable) {
        return this.shareMapper.updateSelective(shareable);
    }

    public Share createByOpenId(String openId, String sourceId, Integer sourceType, String title, String url, String appId) {
        Share share = new Share();
        BaseDomainUtil.initBaseDomain((BaseDomain)share);
        share.setAppId(appId);
        share.setTitle(title);
        share.setUrl(url);
        share.setOpenId(openId);
        share.setSourceId(sourceId);
        share.setSourceType(sourceType);
        return share;
    }
}

