/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.wego168.base.domain.ReviewSummary;
import com.wego168.base.domain.ShortSentence;
import com.wego168.base.persistence.ShortSentenceMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShortSentenceService
extends BaseService<ShortSentence> {
    @Autowired
    private ShortSentenceMapper shortSentenceMapper;

    public CrudMapper<ShortSentence> getMapper() {
        return this.shortSentenceMapper;
    }

    @Transactional
    public void updateList(List<ShortSentence> oldList, List<ShortSentence> newList, ReviewSummary vo) {
        HashMap<String, ShortSentence> map = new HashMap<String, ShortSentence>();
        if (oldList != null && oldList.size() > 0) {
            for (ShortSentence oldShortSentence : oldList) {
                map.put(oldShortSentence.getId(), oldShortSentence);
            }
            for (ShortSentence newShortSentence : newList) {
                if (!StringUtils.isBlank((CharSequence)newShortSentence.getId())) {
                    String key = newShortSentence.getId();
                    if (!map.containsKey(key)) continue;
                    newShortSentence.setAppId(vo.getAppId());
                    newShortSentence.setSourceId(vo.getSourceId());
                    newShortSentence.setSourceType(vo.getSourceType());
                    this.shortSentenceMapper.updateSelective((Object)newShortSentence);
                    map.remove(key);
                    continue;
                }
                newShortSentence.setSourceId(vo.getSourceId());
                newShortSentence.setSourceType(vo.getSourceType());
                newShortSentence.setUseNum(0);
                super.insert((Object)newShortSentence);
            }
            if (map.size() > 0) {
                for (String key : map.keySet()) {
                    ShortSentence shortSentence = (ShortSentence)((Object)map.get(key));
                    shortSentence.setIsDeleted(true);
                    this.shortSentenceMapper.updateSelective((Object)shortSentence);
                }
            }
        } else {
            for (ShortSentence newShortSentence : newList) {
                newShortSentence.setSourceId(vo.getSourceId());
                newShortSentence.setSourceType(vo.getSourceType());
                newShortSentence.setUseNum(0);
            }
            super.insertBatch(newList);
        }
    }
}

