/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignData;
import com.wego168.base.domain.SignDataResponse;
import com.wego168.base.domain.SignDataSetting;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.model.response.ActivitySignDataResponse;
import com.wego168.base.model.response.SignDataDbResponse;
import com.wego168.base.persistence.SignDataMapper;
import com.wego168.base.service.SignDataSettingService;
import com.wego168.domain.GenericDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignDataService
extends BaseService<SignData> {
    private static final Logger log = LoggerFactory.getLogger(SignDataService.class);
    @Autowired
    private SignDataMapper signDataMapper;
    @Autowired
    private SignDataSettingService signDataSettingService;

    public CrudMapper<SignData> getMapper() {
        return this.signDataMapper;
    }

    public List<SignData> selectByDataIds(List<String> dataIdList, Boolean mobile) {
        if (dataIdList != null && dataIdList.size() > 0) {
            return this.signDataMapper.selectByDataIds(dataIdList, mobile);
        }
        return null;
    }

    public SignData selectByFieldName(String dataId, String name) {
        return (SignData)((Object)super.select(JpaCriteria.builder().eq("dataId", (Object)dataId).eq("name", (Object)name)));
    }

    public List<SignData> selectListByDataId(String dataId) {
        return this.signDataMapper.selectList(JpaCriteria.builder().eq("dataId", (Object)dataId));
    }

    public Set<String> selectMobileSetByActivityId(String activityId) {
        HashSet<String> mobileSet = new HashSet<String>();
        List<SignData> mobileSignDateList = this.selectMobileDataByActivityId(activityId);
        if (mobileSignDateList != null && mobileSignDateList.size() > 0) {
            for (SignData signData : mobileSignDateList) {
                mobileSet.add(signData.getValue());
            }
        }
        return mobileSet;
    }

    public List<SignDataDbResponse> selectCheckinNameAndMobileByMobile(String sourceId, String mobile) {
        return this.signDataMapper.selectCheckinNameAndMobileByMobile(sourceId, mobile);
    }

    public List<SignDataDbResponse> selectCheckinNameAndMobile(String sourceId) {
        return this.signDataMapper.selectCheckinNameAndMobile(sourceId);
    }

    public List<SignDataDbResponse> selectCheckinNameAndMobileByMemberId(String sourceId, String memberId) {
        return this.signDataMapper.selectCheckinNameAndMobileByMemberId(sourceId, memberId);
    }

    private List<SignData> selectMobileDataByActivityId(String activityId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().innerJoin(Sign.class).eq(".status", (Object)SignStatusEnum.SIGN.getIndex()).eq(".sourceId", (Object)activityId).eq("name", (Object)"\u624b\u673a");
        return this.selectList(jpaCriteria);
    }

    public List<SignData> selectBySignDataSettingId(List<String> signDataSettingIds, int status, String dataId) {
        return this.signDataMapper.selectBySignDataSettingIdAndDataId(signDataSettingIds, status, dataId);
    }

    public List<SignData> selectBySignDataSettingId(List<String> signDataSettingIds, int status) {
        return this.signDataMapper.selectBySignDataSettingId(signDataSettingIds, status);
    }

    public Map<String, String> batchDownloadSignFile(String activityId, String appId) {
        List<SignData> signDataList = this.signDataMapper.batchDownloadSignFile(activityId, appId);
        HashMap<String, String> signFileMap = new HashMap<String, String>();
        for (SignData signData : signDataList) {
            signFileMap.put(signData.getDataId(), signData.getValue());
        }
        List<SignDataSetting> signDataSettings = this.signDataSettingService.selectByActivityId(activityId, 3);
        List<String> signDataSettingIds = signDataSettings.stream().map(GenericDomain::getId).collect(Collectors.toList());
        List<SignData> signDatas = this.selectBySignDataSettingId(signDataSettingIds, SignStatusEnum.SIGN.getIndex());
        HashMap<String, String> signValueMap = new HashMap<String, String>();
        for (SignDataSetting signDataSetting : signDataSettings) {
            for (SignData signData : signDatas) {
                if (!StringUtil.equals((String)signData.getSettingId(), (String)signDataSetting.getId())) continue;
                String value = (String)signValueMap.get(signData.getDataId());
                if (StringUtil.isBlank((String)value)) {
                    value = "";
                }
                value = value + signData.getValue();
                value = value + " ";
                signValueMap.put(signData.getDataId(), value);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Set key = signFileMap.keySet();
        for (String k : key) {
            String name = (String)signValueMap.get(k);
            if (StringUtil.isNotBlank((String)name)) {
                if (map.containsKey(name = SignDataService.filterIllegalName(name))) {
                    name = name + SequenceUtil.createRandomNumberSequence((int)4);
                }
                map.put(name, (String)signFileMap.get(k));
                continue;
            }
            log.error("name\u4e3a\u7a7a->{}", (Object)k);
        }
        return map;
    }

    private static String filterIllegalName(String name) {
        Pattern p = Pattern.compile("[\\s\\\\/:\\*\\?\\\"<>\\|]");
        Matcher m = p.matcher(name);
        return m.replaceAll(" ");
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(1583115400579L);
        System.out.println(calendar.getTime());
    }

    public SignData selectNameByDataId(String dataId, String activityId) {
        return this.signDataMapper.selectNameByDataId(dataId, activityId, this.getAppId());
    }

    public SignData selectMobileByDataId(String dataId, String activityId) {
        return this.signDataMapper.selectMobileByDataId(dataId, activityId, this.getAppId());
    }

    public List<SignData> selectNameMobileBySignId(String id) {
        return this.signDataMapper.selectNameMobileBySignId(id, this.getAppId());
    }

    public SignData selectSignDataByFieldName(String dataId, String fieldName, String sourceId) {
        return this.signDataMapper.selectSignDataByFieldName(dataId, sourceId, this.getAppId(), fieldName);
    }

    public List<SignDataResponse> selectSignData(String dataId, String sourceId) {
        return this.signDataMapper.selectSignData(dataId, sourceId, this.getAppId());
    }

    public List<ActivitySignDataResponse> selectSignDataBySignIdArray(String[] signIdArray) {
        return this.signDataMapper.selectSignDataBySignIdArray(signIdArray);
    }
}

