/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.SignDataSetting;
import com.wego168.base.persistence.SignDataSettingMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.AppCopyHandler;
import com.wego168.service.BaseService;
import com.wego168.service.InitAppHandler;
import com.wego168.util.AppCopyUtil;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.util.GuidGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SignDataSettingService
extends BaseService<SignDataSetting>
implements InitAppHandler,
AppCopyHandler {
    private static final Logger log = LoggerFactory.getLogger(SignDataSettingService.class);
    @Autowired
    private SignDataSettingMapper signDataSettingMapper;

    public CrudMapper<SignDataSetting> getMapper() {
        return this.signDataSettingMapper;
    }

    private SignDataSetting create(String appId, int type, String name, String fieldName, boolean isSystem, boolean isRequired, boolean isShow, int sort, boolean isSignShow) {
        SignDataSetting tmp = new SignDataSetting();
        BaseDomainUtil.initBaseDomain((BaseDomain)tmp);
        tmp.setAppId(appId);
        tmp.setType(type);
        tmp.setName(name);
        tmp.setFieldName(fieldName);
        tmp.setIsSystem(isSystem);
        tmp.setIsRequired(isRequired);
        tmp.setIsShow(isShow);
        tmp.setSort(sort);
        tmp.setIsSignShow(isSignShow);
        tmp.setIsDeleted(false);
        return tmp;
    }

    public void init(String appId) {
        this.init(appId, "1");
    }

    public int init(String appId, String type) {
        int count;
        int num = 0;
        LinkedList<SignDataSetting> list = new LinkedList<SignDataSetting>();
        if (StringUtils.contains((CharSequence)type, (CharSequence)"1") && (count = this.selectCount(JpaCriteria.builder().eq("appId", (Object)appId).eq("type", (Object)1).eq("isSystem", (Object)true).eq("isDeleted", (Object)false))) == 0) {
            int i = 1;
            list.add(this.create(appId, 1, "\u59d3\u540d", "name", true, true, true, 10 * i++, true));
            list.add(this.create(appId, 1, "\u624b\u673a", "mobile", true, true, true, 10 * i++, true));
            list.add(this.create(appId, 1, "\u516c\u53f8", "company", true, false, true, 10 * i++, true));
            list.add(this.create(appId, 1, "\u804c\u4f4d", "position", true, false, true, 10 * i++, true));
        }
        if (!list.isEmpty()) {
            this.insertBatch(list);
            num = list.size();
        }
        return num;
    }

    @Transactional
    public void saveList(List<SignDataSetting> list) {
        List settingList = super.selectList(JpaCriteria.builder().eq("isSystem", (Object)true));
        HashMap<String, SignDataSetting> map = new HashMap<String, SignDataSetting>();
        HashSet<String> fieldSet = new HashSet<String>();
        for (SignDataSetting signDataSetting : settingList) {
            map.put(signDataSetting.getId(), signDataSetting);
        }
        for (SignDataSetting signDataSetting : list) {
            String fieldName = signDataSetting.getFieldName();
            Shift.throwsIfInvalid((boolean)fieldSet.contains(fieldName), (String)(fieldName + "\u5b57\u6bb5\u5df2\u5b58\u5728"));
            if (StringUtils.isBlank((CharSequence)signDataSetting.getId())) {
                signDataSetting.setId(GuidGenerator.generate());
                signDataSetting.setIsSystem(true);
                super.insert((Object)signDataSetting);
            } else {
                super.updateSelective((Object)signDataSetting);
                map.remove(signDataSetting.getId());
            }
            fieldSet.add(fieldName);
        }
        for (String id : map.keySet()) {
            this.signDataSettingMapper.deleteById(id);
        }
    }

    public List<SignDataSetting> selectByActivityId(String activityId) {
        return this.selectList(JpaCriteria.builder().eq("sourceId", (Object)activityId).orderBy("sort"));
    }

    public List<SignDataSetting> selectByActivityId(String activityId, Integer size) {
        return this.signDataSettingMapper.selectByActivityId(activityId, size);
    }

    public Integer[] checkExcelHeadContainsAllSetting(String[] head, List<SignDataSetting> signDataSettingList) {
        HashSet<String> headSet = new HashSet<String>();
        for (String headCell : head) {
            headSet.add(headCell);
        }
        for (SignDataSetting setting : signDataSettingList) {
            String settingName = setting.getName();
            Checker.checkCondition((!headSet.contains(settingName) ? 1 : 0) != 0, (String)("\u5bfc\u5165\u7684\u8868\u683c\u4e2d\u7f3a\u5c11\u3010" + settingName + "\u3011\u5217"));
        }
        Integer[] signDataSettingIndexArray = new Integer[head.length];
        int arrayIndex = 0;
        for (String headCell : head) {
            int validColumnIndex = -1;
            signDataSettingIndexArray[arrayIndex] = validColumnIndex;
            for (SignDataSetting setting : signDataSettingList) {
                ++validColumnIndex;
                if (!StringUtil.equals((String)headCell, (String)setting.getName())) continue;
                signDataSettingIndexArray[arrayIndex] = validColumnIndex;
                break;
            }
            ++arrayIndex;
        }
        return signDataSettingIndexArray;
    }

    public void copyData(String sourceAppId, String targetAppId) {
        LinkedList<SignDataSetting> list = this.signDataSettingMapper.selectList(JpaCriteria.builder().eq("appId", (Object)sourceAppId).eq("isDeleted", (Object)false));
        List oldList = this.signDataSettingMapper.selectList(JpaCriteria.builder().eq("appId", (Object)targetAppId).eq("isDeleted", (Object)false));
        if (!oldList.isEmpty()) {
            HashSet<String> codeSet = new HashSet<String>();
            for (SignDataSetting c : oldList) {
                codeSet.add(c.getName());
            }
            LinkedList<SignDataSetting> addList = new LinkedList<SignDataSetting>();
            for (SignDataSetting c : list) {
                if (codeSet.contains(c.getName())) continue;
                addList.add(c);
            }
            list = addList;
        }
        if (!list.isEmpty()) {
            AppCopyUtil.copyData((List)list, (String)targetAppId);
            this.signDataSettingMapper.insertBatch(list);
        }
        log.error("\u5171\u590d\u5236{}\u884cSignDataSetting\u6570\u636e", (Object)list.size());
    }
}

