/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Config;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignData;
import com.wego168.base.enums.ConfigEnum;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.enums.SourceTypeEnum;
import com.wego168.base.persistence.SignMapper;
import com.wego168.base.service.ConfigService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SignService
extends BaseService<Sign> {
    @Autowired
    private SignMapper signMapper;
    @Autowired
    private ConfigService configService;

    public CrudMapper<Sign> getMapper() {
        return this.signMapper;
    }

    @Transactional
    public void bindingMemberId(String mobile, String memberId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().rightJoin(SignData.class).eq(".name", (Object)"\u624b\u673a").eq(".value", (Object)mobile);
        List localList = super.selectList(jpaCriteria);
        for (Sign sign : localList) {
            if (!StringUtils.isBlank((CharSequence)sign.getMemberId())) continue;
            sign.setMemberId(memberId);
            this.signMapper.updateSelective((Object)sign);
        }
    }

    public Integer signNum(String sourceId) {
        return super.selectCount(JpaCriteria.builder().eq("sourceId", (Object)sourceId).eq("status", (Object)SignStatusEnum.SIGN.getIndex()));
    }

    public List<Sign> selectSignByActivityId(String id) {
        return this.selectList(JpaCriteria.builder().eq("sourceType", (Object)SourceTypeEnum.ACTIVITY.getIndex()).eq("sourceId", (Object)id).eq("status", (Object)SignStatusEnum.SIGN.getIndex()));
    }

    public Config getSignTips() {
        Config config = this.configService.selectByKey(ConfigEnum.SIGN_TIPS.name(), this.getAppId());
        if (config == null) {
            config = this.configService.create(this.getAppId(), 0, ConfigEnum.SIGN_TIPS.name(), "\u6211\u8981\u62a5\u540d\u6309\u94ae\u63d0\u793a", "\u6211\u8981\u62a5\u540d", null, 1, null, (short)10, true);
            this.configService.insert((Object)config);
        }
        return config;
    }

    public Integer saveOrUpdateSignTips(String tips) {
        int row = 0;
        Config config = this.configService.selectByKey(ConfigEnum.SIGN_TIPS.name(), this.getAppId());
        if (config == null) {
            config = this.configService.create(this.getAppId(), 0, ConfigEnum.SIGN_TIPS.name(), "\u6211\u8981\u62a5\u540d\u6309\u94ae\u63d0\u793a", tips, null, 1, null, (short)10, true);
            row = this.configService.insert((Object)config);
        } else {
            config.setValue(tips);
            row = this.configService.updateSelective((Object)config);
        }
        return row;
    }
}

