/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Content;
import com.wego168.base.domain.SingleContent;
import com.wego168.base.persistence.SingleContentMapper;
import com.wego168.base.service.ContentService;
import com.wego168.base.service.SingleContentTagService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.util.GuidGenerator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SingleContentService
extends BaseService<SingleContent> {
    @Autowired
    private SingleContentMapper singleContentMapper;
    @Autowired
    private ContentService contentService;
    @Autowired
    private SingleContentTagService singleContentTagService;

    public CrudMapper<SingleContent> getMapper() {
        return this.singleContentMapper;
    }

    @Transactional
    public void inserts(SingleContent singleContent) {
        Content content = new Content();
        content.setId(GuidGenerator.generate());
        content.setContent(singleContent.getContent());
        singleContent.setContentId(content.getId());
        singleContent.setCreateBy(this.authenticationUser.getUserId());
        singleContent.setCommentQuantity(0);
        singleContent.setPraiseQuantity(0);
        singleContent.setShareQuantity(0);
        singleContent.setVisitQuantity(0);
        if (singleContent.getReadPoint() == null) {
            singleContent.setReadPoint(0);
        }
        super.insert((Object)singleContent);
        this.contentService.insert(content);
    }

    @Transactional
    public void updates(SingleContent singleContent) {
        String content = singleContent.getContent();
        Content content2 = new Content();
        if (StringUtils.isNotBlank((CharSequence)singleContent.getContentId())) {
            content2.setId(singleContent.getContentId());
            content2.setContent(content);
            this.contentService.updateSelective(content2);
        } else {
            content2.setId(GuidGenerator.generate());
            content2.setContent(content);
            this.contentService.insert(content2);
            singleContent.setContentId(content2.getId());
        }
        if (singleContent.getReadPoint() == null) {
            singleContent.setReadPoint(0);
        }
        super.updateSelective((Object)singleContent);
    }

    public SingleContent get(String id) {
        SingleContent singleContent = (SingleContent)this.singleContentMapper.selectById(id);
        Shift.throwsIfInvalid((singleContent == null || singleContent.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        if (singleContent != null && StringUtils.isNotBlank((CharSequence)singleContent.getContentId())) {
            Content content = (Content)this.contentService.selectById(singleContent.getContentId());
            singleContent.setContent(content.getContent());
        }
        return singleContent;
    }

    public List<SingleContent> selectSingleContentPageByAdmin(String orderBy, Page page) {
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)false);
        page.put((Object)"orderBySql", (Object)this.determineOrderBySql(orderBy));
        return this.singleContentMapper.selectSingleContentPageByAdmin(page);
    }

    public List<SingleContent> selectSingleContentPage(String orderBy, Page page) {
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)false);
        page.put((Object)"isDisplay", (Object)true);
        page.put((Object)"orderBySql", (Object)this.determineOrderBySql(orderBy));
        return this.singleContentMapper.selectSingleContentPage(page);
    }

    public SingleContent getById(String id) {
        SingleContent singleContent = this.get(id);
        return this.singleContentTagService.selectBySinglecontent(singleContent);
    }

    private String determineOrderBySql(String orderBy) {
        String orderBySql = "c.seq_num ASC, sc.`create_time` DESC";
        if (StringUtil.equals((String)orderBy, (String)"newFirst")) {
            orderBySql = "sc.create_time DESC";
        }
        return orderBySql;
    }

    public int deleteBatch(List<String> ids) {
        return this.getMapper().updateSelective((Object)JpaCriteria.builder().set("isDeleted", (Object)true).in("id", ids.toArray()));
    }
}

