/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.SourceData;
import com.wego168.base.persistence.SourceDataMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SourceDataService
extends BaseService<SourceData> {
    @Autowired
    private SourceDataMapper sourceDataMapper;

    public CrudMapper<SourceData> getMapper() {
        return this.sourceDataMapper;
    }

    public SourceData create(String sourceId, int sourceType, String title, String appId) {
        SourceData sourceData = new SourceData();
        BaseDomainUtil.initBaseDomain((BaseDomain)sourceData);
        sourceData.setAppId(appId);
        sourceData.setCommentQuantity(0);
        sourceData.setHeatRate(0);
        sourceData.setPraiseQuantity(0);
        sourceData.setShareQuantity(0);
        sourceData.setAppendQuantity(0);
        sourceData.setSourceId(sourceId);
        sourceData.setSourceType(sourceType);
        sourceData.setTitle(title);
        sourceData.setVisitQuantity(0);
        return sourceData;
    }

    public SourceData selectBySourceId(String sourceId) {
        return (SourceData)super.select(JpaCriteria.builder().eq("sourceId", (Object)sourceId));
    }

    public SourceData updateHeatRate(String sourceId, Integer score) {
        SourceData sourceData = this.selectBySourceId(sourceId);
        if (sourceData != null) {
            sourceData.setHeatRate(sourceData.getHeatRate() + score);
            sourceData.setUpdateTime(new Date());
            super.updateSelectiveByLockVersion((Object)sourceData);
            return sourceData;
        }
        return null;
    }
}

