/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.Storable;
import com.wego168.base.service.FileServerService;
import com.wego168.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorableService {
    @Autowired
    private FileServerService fileServerService;

    public void assembleHost(Storable storable) {
        FileServer server;
        String serverId;
        if (storable != null && StringUtil.isNotBlank((String)(serverId = storable.getServerId())) && (server = (FileServer)this.fileServerService.selectById(serverId)) != null) {
            String host = server.getHost();
            storable.setHost(host);
            if (StringUtil.isNotBlank((String)server.getCdn())) {
                storable.setHost(server.getCdn());
            }
        }
    }

    public void assembleHost(Storable storable, FileServer server) {
        if (server != null) {
            String host = server.getHost();
            storable.setHost(host);
            if (StringUtil.isNotBlank((String)server.getCdn())) {
                storable.setHost(server.getCdn());
            }
        }
    }

    public void assembleHost(List<? extends Storable> list) {
        if (list != null && list.size() > 0) {
            HashSet<String> serverIdSet = new HashSet<String>();
            for (Storable storable : list) {
                String string = storable.getServerId();
                serverIdSet.add(string);
            }
            Map<String, FileServer> serverMap = this.fileServerService.selectMapByIdSet(serverIdSet);
            for (Storable storable : list) {
                if (serverMap == null) continue;
                FileServer server = serverMap.get(storable.getServerId());
                this.assembleHost(storable, server);
            }
        }
    }
}

