/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.wego168.base.config.BaseStorageConfig;
import com.wego168.base.enums.StorageType;
import com.wego168.base.service.facade.IStorageService;
import com.wego168.exception.ParameterInvalidException;
import com.wego168.util.StringUtil;
import com.wego168.web.util.SpringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StorageDecider {
    @Value(value="${storage.scene.common}")
    String commonSceneType;

    public IStorageService decide(String type) {
        String configBeanName = StringUtil.deCapitalize((String)type) + "StorageConfig";
        BaseStorageConfig config = (BaseStorageConfig)SpringUtil.getBean((String)configBeanName, BaseStorageConfig.class);
        if (config == null || !config.enabled()) {
            throw new ParameterInvalidException(1009, type + "\u7c7b\u578b\u5b58\u50a8\u672a\u914d\u7f6e\u6216\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5storage.*\u914d\u7f6e");
        }
        String serviceBeanName = StringUtil.deCapitalize((String)type) + "StorageService";
        IStorageService service = (IStorageService)SpringUtil.getBean((String)serviceBeanName, IStorageService.class);
        return service;
    }

    public IStorageService decide() {
        if (StringUtil.isBlank((String)this.commonSceneType)) {
            return this.decide(StorageType.DEFAULT.value());
        }
        return this.decide(this.commonSceneType);
    }
}

