/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Tag;
import com.wego168.base.enums.TagTypeEnum;
import com.wego168.base.persistence.TagMapper;
import com.wego168.base.service.facade.DictCodeHandler;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TagService
extends BaseService<Tag>
implements DictCodeHandler<Tag> {
    @Autowired
    private TagMapper tagMapper;

    @Override
    public CrudMapper<Tag> getMapper() {
        return this.tagMapper;
    }

    public Tag selectByCode(String code) {
        return (Tag)super.select(JpaCriteria.builder().eq("code", (Object)code).eq("isDeleted", (Object)false).eq("appId", (Object)this.getAppId()));
    }

    public boolean isPresentCode(String code) {
        List list = super.selectList(JpaCriteria.builder().eq("code", (Object)code));
        return list != null && list.size() != 0;
    }

    public Tag selectByName(String name) {
        return (Tag)super.select(JpaCriteria.builder().eq("name", (Object)name).eq("isDeleted", (Object)false).eq("appId", (Object)this.getAppId()).eq("type", (Object)TagTypeEnum.SINGLE_CONTENT.getIndex()));
    }

    public List<Tag> selectListByType(Integer type) {
        return super.selectList(JpaCriteria.builder().eq("type", (Object)type));
    }

    public boolean isPresent(String name, int type) {
        List list = super.selectList(JpaCriteria.builder().eq("name", (Object)name).eq("type", (Object)type));
        return list != null && list.size() != 0;
    }
}

