/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import com.wego168.base.config.TencentCloudCosStorageConfig;
import com.wego168.base.model.response.FileUploadResponse;
import com.wego168.base.service.facade.IStorageService;
import com.wego168.exception.HttpException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TencentCloudCosStorageService
implements IStorageService {
    @Autowired
    TencentCloudCosStorageConfig config;
    Logger logger = LoggerFactory.getLogger(TencentCloudCosStorageService.class);

    @Override
    public FileUploadResponse put(String bucket, String filePathAndName, InputStream in, Map<String, String> metaData) {
        Checker.checkCondition((boolean)filePathAndName.startsWith("/"), (String)"\u8def\u5f84\u4e0d\u80fd\u4ee5/\u5f00\u5934\uff01");
        String tencentCloudCosAppId = this.config.getAppId();
        String secretId = this.config.getSecretId();
        String secretKey = this.config.getSecretKey();
        if (StringUtil.isBlank((String)bucket)) {
            bucket = this.config.getBucket();
        }
        BasicCOSCredentials cred = new BasicCOSCredentials(tencentCloudCosAppId, secretId, secretKey);
        String area = this.config.getArea();
        ClientConfig clientConfig = new ClientConfig(new Region(area));
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        try {
            objectMetadata.setContentLength((long)in.available());
        }
        catch (IOException e) {
            objectMetadata.setContentLength(524288L);
        }
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, filePathAndName, in, objectMetadata);
        cosClient.putObject(putObjectRequest);
        FileUploadResponse response = new FileUploadResponse();
        if (StringUtil.isNotBlank((String)this.config.getCdnHost())) {
            response.setHost(this.config.getCdnHost());
        } else {
            response.setHost(this.config.getHost());
        }
        response.setUrl("/" + filePathAndName);
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUploadResponse put(String dirPath, String key, byte[] bytes, Map<String, String> metaData) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            FileUploadResponse fileUploadResponse = this.put(dirPath, key, in, metaData);
            return fileUploadResponse;
        }
        catch (IOException e) {
            this.logger.error("\u817e\u8baf\u4e91\u4e0a\u4f20cos\u5931\u8d25\uff1a{}", (Throwable)e);
            throw HttpException.writeError();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUploadResponse put(String bucket, String filePathAndName, File localFile, Map<String, String> metaData) {
        try (FileInputStream in = new FileInputStream(localFile);){
            FileUploadResponse fileUploadResponse = this.put(bucket, filePathAndName, in, metaData);
            return fileUploadResponse;
        }
        catch (IOException e) {
            this.logger.error("\u817e\u8baf\u4e91\u4e0a\u4f20cos\u5931\u8d25\uff1a{}", (Throwable)e);
            throw HttpException.writeError();
        }
    }

    @Override
    public FileUploadResponse simplePut(String filePathAndName, InputStream in) {
        return this.put(null, filePathAndName, in, null);
    }

    @Override
    public FileUploadResponse simplePut(String filePathAndName, byte[] bytes) {
        return this.put(null, filePathAndName, bytes, null);
    }

    @Override
    public FileUploadResponse simplePut(String filePathAndName, File localFile) {
        return this.put(null, filePathAndName, localFile, null);
    }
}

