/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.wego168.base.domain.Visit;
import com.wego168.base.domain.Visitable;
import com.wego168.base.persistence.VisitMapper;
import com.wego168.base.service.callback.Callback;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.RequestUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VisitService
extends CrudService<Visit> {
    @Autowired
    private VisitMapper visitMapper;

    public CrudMapper<Visit> getMapper() {
        return this.visitMapper;
    }

    public Visit create(String memberId, String sourceId, int sourceType, String title, String appId, HttpServletRequest request) {
        Visit visit = new Visit();
        BaseDomainUtil.initBaseDomain((BaseDomain)visit);
        visit.setAppId(appId);
        visit.setBrowser(RequestUtil.getBrowser((HttpServletRequest)request));
        visit.setIp(RequestUtil.getRealIp((HttpServletRequest)request));
        visit.setOs(RequestUtil.getOperationSystem((HttpServletRequest)request));
        visit.setTitle(title);
        visit.setUrl(RequestUtil.getCurrentUrl((HttpServletRequest)request));
        visit.setMemberId(memberId);
        visit.setSourceId(sourceId);
        visit.setSourceType(sourceType);
        return visit;
    }

    @Transactional
    public void addVisit(Visit visit, Visitable visitable, Callback<Visitable> callback) {
        this.visitMapper.insert((Object)visit);
        callback.execute(visitable);
    }

    public int updateSelective(Visitable visitable) {
        return this.visitMapper.updateSelective(visitable);
    }
}

