/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.App;
import com.wego168.base.domain.WechatShareConfig;
import com.wego168.base.persistence.WechatShareConfigMapper;
import com.wego168.base.service.AppService;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.AppCopyHandler;
import com.wego168.service.BaseService;
import com.wego168.service.InitAppHandler;
import com.wego168.util.AppCopyUtil;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.EnvironmentUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class WechatShareConfigService
extends BaseService<WechatShareConfig>
implements InitAppHandler,
AppCopyHandler {
    private static final Logger log = LoggerFactory.getLogger(WechatShareConfigService.class);
    @Autowired
    private WechatShareConfigMapper wechatShareMapper;
    @Autowired
    private Environment env;
    @Autowired
    private AppService appService;

    public CrudMapper<WechatShareConfig> getMapper() {
        return this.wechatShareMapper;
    }

    public WechatShareConfig create(String code, String title, String description, String image, String url, String appId) {
        WechatShareConfig config = new WechatShareConfig();
        BaseDomainUtil.initBaseDomain((BaseDomain)config);
        config.setAppId(appId);
        config.setCode(code);
        config.setDescription(description);
        config.setImage(image);
        config.setUrl(url);
        config.setTitle(title);
        return config;
    }

    public void init(String appId) {
        App app = this.appService.selectByAppId(appId);
        if (app != null) {
            this.init(appId, app.getName(), app.getLogUrl(), EnvironmentUtil.getDomain((Environment)this.env) + "/" + app.getCode(), "activity");
            this.init(appId, app.getName(), app.getLogUrl(), EnvironmentUtil.getDomain((Environment)this.env) + "/" + app.getCode(), "store");
            this.init(appId, app.getName(), app.getLogUrl(), EnvironmentUtil.getDomain((Environment)this.env) + "/" + app.getCode(), "coweb");
        }
    }

    public int init(String appId, String appName, String logoUrl, String urlPre, String type) {
        WechatShareConfig c;
        int num = 0;
        String uri = urlPre + "/mobile/POUND/";
        String param = "?wo=1&wot=2&woacm=1&mpl=1&from=singlemessage&isappinstalled=0";
        LinkedList<WechatShareConfig> list = new LinkedList<WechatShareConfig>();
        if (StringUtils.isBlank((CharSequence)logoUrl)) {
            logoUrl = "/attachments/qc-logo.png";
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"activity")) {
            c = this.create("activity", appName, "\u6d3b\u52a8\u9996\u9875", logoUrl, uri + "activity" + param, appId);
            list.add(c);
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"store")) {
            c = this.create("store", appName, "\u5546\u57ce\u9996\u9875", logoUrl, uri + "store" + param, appId);
            list.add(c);
        }
        if (StringUtils.contains((CharSequence)type, (CharSequence)"coweb")) {
            c = this.create("coweb", " %s\u6b63\u5728\u9080\u8bf7\u60a8\u52a0\u5165\uff0c\u9a6c\u4e0a\u6765\u4f53\u9a8c\u5427~", "\u793e\u7fa4\u9996\u9875", logoUrl, uri + "coweb" + param, appId);
            list.add(c);
        }
        for (WechatShareConfig c2 : list) {
            WechatShareConfig tmp = this.selectByCode(c2.getCode(), appId);
            if (tmp != null) continue;
            this.insert((Object)c2);
            ++num;
        }
        return num;
    }

    public int update(String title, String description, String image, String url, String id) {
        WechatShareConfig config = new WechatShareConfig();
        config.setDescription(description);
        config.setImage(image);
        config.setUrl(url);
        config.setTitle(title);
        config.setUpdateTime(new Date());
        config.setId(id);
        return this.wechatShareMapper.updateSelective((Object)config);
    }

    public List<WechatShareConfig> selectList(String appId, Page page) {
        page.eq("appId", (Object)appId).orderBy("code asc");
        return super.selectPage(page);
    }

    public WechatShareConfig selectByCode(String code, String appId) {
        return (WechatShareConfig)((Object)this.wechatShareMapper.select(JpaCriteria.builder().eq("code", (Object)code).eq("appId", (Object)appId)));
    }

    public void copyData(String sourceAppId, String targetAppId) {
        LinkedList<WechatShareConfig> list = this.wechatShareMapper.selectList(JpaCriteria.builder().eq("appId", (Object)sourceAppId).eq("isDeleted", (Object)false));
        List oldList = this.wechatShareMapper.selectList(JpaCriteria.builder().eq("appId", (Object)targetAppId).eq("isDeleted", (Object)false));
        if (!oldList.isEmpty()) {
            HashSet<String> codeSet = new HashSet<String>();
            for (WechatShareConfig c : oldList) {
                codeSet.add(c.getCode());
            }
            LinkedList<WechatShareConfig> addList = new LinkedList<WechatShareConfig>();
            for (WechatShareConfig c : list) {
                if (codeSet.contains(c.getCode())) continue;
                addList.add(c);
            }
            list = addList;
        }
        if (!list.isEmpty()) {
            AppCopyUtil.copyData((List)list, (String)targetAppId);
            this.wechatShareMapper.insertBatch(list);
        }
        log.error("\u5171\u590d\u5236{}\u884cWechatShareConfig\u6570\u636e", (Object)list.size());
    }
}

