/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.service.facade;

import com.github.stuxuhai.jpinyin.PinyinHelper;
import com.simple.mybatis.JpaCriteria;
import com.wego168.base.service.facade.DictCode;
import com.wego168.domain.BaseDomain;
import com.wego168.domain.TreeDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.Shift;
import com.wego168.util.SimpleJackson;
import com.wego168.util.SimpleTree;
import com.wego168.web.util.GuidGenerator;
import com.wego168.web.util.SpringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public interface DictCodeHandler<R extends DictCode> {
    public CrudMapper<? extends BaseDomain> getMapper();

    public Class getClassGenericType(Class var1);

    default public SimpleRedisTemplate getSimpleRedisTemplate() {
        return (SimpleRedisTemplate)SpringUtil.getBean(SimpleRedisTemplate.class);
    }

    default public R selectByCode(String code, String appId) {
        DictCode dict = (DictCode)this.getMapper().select(JpaCriteria.builder().eq("code", (Object)code).eq("isDeleted", (Object)false).eq("appId", (Object)appId));
        return (R)dict;
    }

    default public String getByCode(R r) {
        Shift.throwsIfBlank((String)r.getAppId(), (String)"\u83b7\u53d6\u5b57\u5178\u4ee3\u7801\u7684\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)r.getCode())) {
            R dbDict = this.selectByCode(r.getCode(), r.getAppId());
            Shift.throwsIfInvalid((dbDict != null && !dbDict.getId().equals(r.getId()) ? 1 : 0) != 0, (String)"\u4ee3\u7801\u5df2\u5b58\u5728");
            result = r.getCode();
        } else {
            try {
                String code = PinyinHelper.getShortPinyin((String)r.getName());
                R dbDict = this.selectByCode(code, r.getAppId());
                if (dbDict != null) {
                    if (!dbDict.getId().equals(r.getId())) {
                        result = GuidGenerator.generate();
                    }
                } else {
                    result = code;
                }
            }
            catch (Exception e) {
                result = GuidGenerator.generate();
            }
        }
        return result;
    }

    default public void refreshParentIdCache(TreeDomain tree) {
        LinkedList<String> list = new LinkedList<String>();
        list.add(tree.getParentId());
        List<String> parentIdList = this.listParentIdByCache(tree.getParentId());
        if (parentIdList != null && parentIdList.size() > 0) {
            list.addAll(parentIdList);
        }
        this.getSimpleRedisTemplate().set(this.getDictParentCacheKeyPrefix(tree.getId()), (Object)SimpleJackson.toJson(list));
    }

    default public List<String> listParentIdByCache(String ... id) {
        LinkedList<String> idList = new LinkedList<String>();
        for (String v : id) {
            String json = this.getSimpleRedisTemplate().getString(this.getDictParentCacheKeyPrefix(v));
            if (!StringUtils.isNotBlank((CharSequence)json)) continue;
            List cacheList = SimpleJackson.toList((String)json, String.class);
            cacheList.forEach(e -> {
                if (!idList.contains(e)) {
                    idList.add((String)e);
                }
            });
        }
        return idList;
    }

    default public void initParentCache(List list) {
        if (Objects.nonNull(list)) {
            SimpleTree simpleTree = new SimpleTree();
            Map map = simpleTree.initParentList(list);
            for (String key : map.keySet()) {
                this.getSimpleRedisTemplate().setString(this.getDictParentCacheKeyPrefix(key), SimpleJackson.toJson(map.get(key)));
            }
        }
    }

    default public String getDictParentCacheKeyPrefix(String id) {
        String name = this.getClassGenericType(this.getClass()).getName();
        return name.substring(name.lastIndexOf(".") + 1) + "_parent_list_" + id;
    }
}

