/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.util;

import com.wego168.base.model.AdvancedSensitiveWordNode;
import com.wego168.base.model.Character;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class AdvancedSensitiveWordUtil {
    public static AdvancedSensitiveWordNode build(List<String> sensitiveWordList) {
        AdvancedSensitiveWordNode root = new AdvancedSensitiveWordNode(new Character('0'), false);
        for (String sensitiveWord : sensitiveWordList) {
            int wordLength = sensitiveWord.length();
            AdvancedSensitiveWordNode currentNode = null;
            for (int i = 0; i < wordLength; ++i) {
                Character character = new Character(sensitiveWord.charAt(i));
                boolean end = IntegerUtil.equals((Integer)i, (Integer)(wordLength - 1));
                AdvancedSensitiveWordNode newNode = new AdvancedSensitiveWordNode(character, end);
                if (currentNode == null) {
                    currentNode = root.get(character);
                    if (root.contains(character)) continue;
                    root.put(character, newNode);
                    currentNode = newNode;
                    continue;
                }
                if (!currentNode.contains(character)) {
                    currentNode.put(character, newNode);
                    currentNode.setEnd(false);
                    currentNode = newNode;
                    continue;
                }
                currentNode = currentNode.get(character);
            }
        }
        return root;
    }

    public static List<String> fullMatch(String text, AdvancedSensitiveWordNode root) {
        ArrayList<String> matchedSensitiveWords = new ArrayList<String>();
        StringBuffer sensitiveWordBuffer = new StringBuffer();
        AdvancedSensitiveWordNode current = root;
        for (int i = 0; i < text.length(); ++i) {
            Character character = new Character(text.charAt(i));
            AdvancedSensitiveWordNode node = current.get(character);
            if (node != null) {
                sensitiveWordBuffer.append(character);
                current = node;
                if (!node.isEnd()) continue;
                matchedSensitiveWords.add(sensitiveWordBuffer.toString());
                current = root;
                sensitiveWordBuffer = new StringBuffer();
                continue;
            }
            sensitiveWordBuffer = new StringBuffer();
            current = root;
        }
        return Checker.listIsEmpty(matchedSensitiveWords) ? null : matchedSensitiveWords;
    }

    public static String firstMatch(String text, AdvancedSensitiveWordNode root) {
        String firstSenstiveWord;
        StringBuffer sensitiveWordBuffer = new StringBuffer();
        AdvancedSensitiveWordNode current = root;
        for (int i = 0; i < text.length(); ++i) {
            Character character = new Character(text.charAt(i));
            AdvancedSensitiveWordNode node = current.get(character);
            if (node != null) {
                sensitiveWordBuffer.append(character);
                current = node;
                if (!node.isEnd()) continue;
                break;
            }
            sensitiveWordBuffer = new StringBuffer();
            current = root;
        }
        return StringUtil.isBlank((String)(firstSenstiveWord = sensitiveWordBuffer.toString())) ? null : firstSenstiveWord;
    }

    public static void main(String[] args) {
        ArrayList<String> sensitiveWordList = new ArrayList<String>();
        sensitiveWordList.add("\u56de\u6263");
        sensitiveWordList.add("\u7ea2\u5305");
        sensitiveWordList.add("\u52a0\u6211");
        sensitiveWordList.add("\u52a0\u5fae\u4fe1");
        AdvancedSensitiveWordNode root = AdvancedSensitiveWordUtil.build(sensitiveWordList);
        String text = "\u7ea2\u5305\u4f60\u6536\u4e86\uff0c\u8be5\u8fe6\u672a\u4fe1\u4e86\u5427";
        System.out.println(AdvancedSensitiveWordUtil.firstMatch(text, root));
        System.out.println(AdvancedSensitiveWordUtil.fullMatch(text, root));
        text = "\u5218\u90a6\u7684\u7ea6\u6cd5\u4e09\u7ae0\uff0c\u4ee4\u4ed6\u5728\u5173\u4e2d\u589e\u52a0\u5a01\u4fe1\u4e0d\u5c11";
        System.out.println(AdvancedSensitiveWordUtil.firstMatch(text, root));
        System.out.println(AdvancedSensitiveWordUtil.fullMatch(text, root));
        text = "\u4e39\u4e39\uff0c\u54b1\u5904\u4e86\u8fd9\u4e48\u4e45\uff0c\u8be5\u5ac1\u6211\u4e86\u5427";
        System.out.println(AdvancedSensitiveWordUtil.firstMatch(text, root));
        System.out.println(AdvancedSensitiveWordUtil.fullMatch(text, root));
        text = "\u4f60\u8863\u670d\u6389\u7684\u662f\u7070\u6263\u5b50\u8fd8\u662f\u9ed1\u6263\u5b50\u56de\u6263";
        System.out.println(AdvancedSensitiveWordUtil.firstMatch(text, root));
        System.out.println(AdvancedSensitiveWordUtil.fullMatch(text, root));
    }
}

