/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.util;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.region.Region;
import com.wego168.base.domain.CosBucket;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class COSClientUtil {
    private static String bucketName;
    private static COSClient cosClient;

    public static void init(CosBucket cosBucket) {
        BasicCOSCredentials cred = new BasicCOSCredentials(cosBucket.getCosAppId(), cosBucket.getSecretId(), cosBucket.getSecretKey());
        ClientConfig clientConfig = new ClientConfig(new Region(cosBucket.getRegion()));
        cosClient = new COSClient((COSCredentials)cred, clientConfig);
        bucketName = cosBucket.getBucketName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadFile2Cos(CosBucket cosBucket, MultipartFile file, String pathName) {
        COSClientUtil.init(cosBucket);
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            cosClient.putObject(bucketName, pathName, inputStream, objectMetadata);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CosClientException cle) {
            cle.printStackTrace();
        }
        finally {
            try {
                cosClient.shutdown();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

