/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.wego168.exception.FileException;
import com.wego168.exception.HttpException;
import com.wego168.util.Checker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, boolean isCreateHeader, HttpServletResponse response) {
        ExportParams exportParams = new ExportParams(title, sheetName);
        exportParams.setCreateHeadRows(isCreateHeader);
        FileUtil.defaultExport(list, pojoClass, fileName, response, exportParams);
    }

    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, HttpServletResponse response) {
        FileUtil.defaultExport(list, pojoClass, fileName, response, new ExportParams(title, sheetName));
    }

    public static void exportExcel(List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
        FileUtil.defaultExport(list, fileName, response);
    }

    private static void defaultExport(List<?> list, Class<?> pojoClass, String fileName, HttpServletResponse response, ExportParams exportParams) {
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, pojoClass, list);
        if (workbook != null) {
            // empty if block
        }
        FileUtil.downLoadExcel(fileName, response, workbook);
    }

    public static void downLoadExcel(String fileName, HttpServletResponse response, Workbook workbook) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    private static void defaultExport(List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
        Workbook workbook = ExcelExportUtil.exportExcel(list, (ExcelType)ExcelType.HSSF);
        if (workbook != null) {
            // empty if block
        }
        FileUtil.downLoadExcel(fileName, response, workbook);
    }

    public static <T> List<T> importExcel(String filePath, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((File)new File(filePath), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            throw new ValidationException("\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ValidationException(e.getMessage());
        }
        return list;
    }

    public static <T> List<T> importExcel(MultipartFile file, ImportParams params, Class<?> pojoClass) {
        if (file == null) {
            return null;
        }
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            throw new ValidationException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage());
        }
        return list;
    }

    public static void main(String[] args) {
        FileUtil.downloadFile("http://mmbiz.qpic.cn/mmbiz_jpg/yrEzWwoNKJUyuJmSOWCdc8UylFmLBwvf1zcZdEibUibZEKzhDfibBia61V0KbymSTklEMXv02ib7IR7ybPty0ic4U6gw/0", "2.png", "E:/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File downloadFile(String netFileUrl, String localFileName, String localFilePath) {
        byte[] img = FileUtil.getByteFromUrl(netFileUrl, 3);
        File directory = new File(localFilePath);
        if (!directory.exists() || !directory.isDirectory()) {
            directory.mkdirs();
        }
        String imgPath = localFilePath + File.separator + localFileName;
        File file = new File(imgPath);
        try (FileOutputStream fops = new FileOutputStream(file);){
            fops.write(img);
            fops.flush();
            File file2 = file;
            return file2;
        }
        catch (FileNotFoundException e) {
            throw FileException.fileNotExist();
        }
        catch (IOException e) {
            throw FileException.writeFileError();
        }
    }

    public static void copyFileWithDirectMemory(File sourceFile, File targetFile) {
        try (FileInputStream in = new FileInputStream(sourceFile);
             FileChannel inChannel = in.getChannel();
             FileOutputStream out = new FileOutputStream(targetFile);
             FileChannel outChannel = out.getChannel();){
            int len;
            ByteBuffer bb = ByteBuffer.allocateDirect(0x100000);
            while ((len = inChannel.read(bb)) != -1) {
                bb.flip();
                outChannel.write(bb);
                bb.clear();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u590d\u5236\u6587\u4ef6\u5931\u8d25");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String md5(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] bytes = new byte[((InputStream)inputStream).available()];
            ((InputStream)inputStream).read(bytes);
            String string = FileUtil.md5(bytes);
            return string;
        }
        catch (FileNotFoundException e) {
            Checker.checkCondition((boolean)true, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            return null;
        }
        catch (IOException e) {
            Checker.checkCondition((boolean)true, (String)"\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
        return null;
    }

    public static String md5(byte[] bytes) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        md5.update(bytes, 0, bytes.length);
        return new String(Hex.encodeHex((byte[])md5.digest()));
    }

    private static byte[] getByteFromUrl(String strUrl, int connectTimeOutSeconds) {
        HttpURLConnection httpUrlConn = null;
        byte[] btImg = null;
        URL url = null;
        try {
            url = new URL(strUrl);
        }
        catch (MalformedURLException e) {
            throw HttpException.invalidUrl();
        }
        try {
            httpUrlConn = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw HttpException.connectError();
        }
        try {
            httpUrlConn.setRequestMethod("GET");
        }
        catch (ProtocolException e) {
            throw HttpException.connectError();
        }
        httpUrlConn.setConnectTimeout(connectTimeOutSeconds * 1000);
        try (InputStream inputStream = httpUrlConn.getInputStream();
             ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            inputStream.close();
            btImg = outStream.toByteArray();
        }
        catch (IOException e) {
            throw HttpException.readError();
        }
        if (btImg == null || btImg.length == 0) {
            throw HttpException.readError();
        }
        return btImg;
    }

    public static String getFileSubfix(String fileNameOrUrl) {
        String subfix = "";
        int dotIndex = fileNameOrUrl.lastIndexOf(".");
        if (dotIndex > 0) {
            subfix = fileNameOrUrl.substring(dotIndex);
        }
        return subfix;
    }

    public static String getFileSubfixWithoutDot(String fileNameOrUrl) {
        String subfix = "";
        int dotIndex = fileNameOrUrl.lastIndexOf(".");
        if (dotIndex > 0) {
            subfix = fileNameOrUrl.substring(dotIndex + 1);
        }
        return subfix;
    }
}

