/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.util;

import com.wego168.base.domain.Poster;
import com.wego168.base.enums.PosterTypeEnum;
import com.wego168.util.Shift;
import java.awt.AlphaComposite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;

public class ImageUtil {
    public static BufferedImage posterCombine(BufferedImage basicImage, List<Poster> list) {
        Graphics2D g = basicImage.createGraphics();
        for (Poster poster : list) {
            Integer type = poster.getType();
            if (type.intValue() == PosterTypeEnum.IMAGE.value()) {
                BufferedImage bufferedImage = poster.getBufferImage();
                Shift.throwsIfNull((Object)bufferedImage, (String)"\u56fe\u7247\u4e0d\u5b58\u5728");
                if (poster.getWidth() != null && poster.getHeight() != null) {
                    bufferedImage = ImageUtil.scaleByPercentage(bufferedImage, poster.getWidth(), poster.getHeight());
                }
                if (poster.getIsCircle().booleanValue()) {
                    bufferedImage = ImageUtil.convertHeadCircular(bufferedImage);
                }
                Integer x = poster.getX();
                Integer y = poster.getY();
                if (poster.getIsHorizontalMiddle().booleanValue()) {
                    x = (basicImage.getWidth() - bufferedImage.getWidth()) / 2;
                }
                if (poster.getIsVerticalMiddle().booleanValue()) {
                    y = (basicImage.getHeight() - bufferedImage.getHeight()) / 2;
                }
                g.drawImage(bufferedImage, x, y, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                continue;
            }
            if (type.intValue() == PosterTypeEnum.TEXT.value()) {
                Shift.throwsIfBlank((String)poster.getTextContent(), (String)"\u6587\u5b57\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                if (poster.getFont() != null) {
                    g.setFont(poster.getFont());
                }
                if (poster.getTextColor() != null) {
                    g.setColor(poster.getTextColor());
                }
                FontMetrics fontMetrics = g.getFontMetrics();
                int x = 0;
                int y = 0;
                if (poster.getIsHorizontalMiddle().booleanValue()) {
                    int textWidth = fontMetrics.stringWidth(poster.getTextContent());
                    x = (basicImage.getWidth() - textWidth) / 2;
                } else {
                    x = poster.getX();
                }
                if (poster.getIsVerticalMiddle().booleanValue()) {
                    int textHight = fontMetrics.getAscent();
                    y = (basicImage.getHeight() + textHight - fontMetrics.getDescent()) / 2;
                } else {
                    y = poster.getY();
                }
                g.drawString(poster.getTextContent(), x, y);
                continue;
            }
            if (type.intValue() != PosterTypeEnum.LINE.value()) continue;
            if (poster.getTextColor() != null) {
                g.setColor(poster.getTextColor());
            }
            if (poster.getBasicStroke() != null) {
                g.setStroke(poster.getBasicStroke());
            }
            g.drawLine(poster.getX(), poster.getY(), poster.getX2(), poster.getY2());
        }
        g.dispose();
        return basicImage;
    }

    public static BufferedImage scaleByPercentage(BufferedImage inputImage, int newWidth, int newHeight) {
        int type = inputImage.getColorModel().getTransparency();
        int width = inputImage.getWidth();
        int height = inputImage.getHeight();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        BufferedImage img = new BufferedImage(newWidth, newHeight, type);
        Graphics2D graphics2d = img.createGraphics();
        graphics2d.setRenderingHints(renderingHints);
        graphics2d.drawImage(inputImage, 0, 0, newWidth, newHeight, 0, 0, width, height, null);
        graphics2d.dispose();
        return img;
    }

    public static BufferedImage convertHeadCircular(BufferedImage bi1) {
        BufferedImage bi2 = new BufferedImage(bi1.getWidth(), bi1.getHeight(), 6);
        Graphics2D g2 = bi2.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fillRoundRect(0, 0, bi1.getWidth(), bi1.getHeight(), bi1.getWidth(), bi1.getHeight());
        g2.setComposite(AlphaComposite.SrcIn);
        g2.drawImage(bi1, 0, 0, bi1.getWidth(), bi1.getHeight(), null);
        g2.dispose();
        return bi2;
    }
}

