/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.util;

import com.github.qcloudsms.SmsSingleSenderResult;
import com.wego168.base.domain.MobileMsg;
import com.wego168.base.persistence.MobileMsgMapper;
import com.wego168.base.util.SmsResponse;
import com.wego168.base.util.WegoSmsSingleSender;
import com.wego168.exception.SendMobileMessageFailException;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.util.GuidGenerator;
import com.wego168.web.util.SpringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MobileMessageUtil {
    private static WegoSmsSingleSender create(int cloudAppId, String appSecret, String templateName) throws Exception {
        return new WegoSmsSingleSender(cloudAppId, appSecret, templateName);
    }

    public static SmsResponse sendMessage(String mobileTelephoneNumber, List<String> list, int templateId, int cloudAppId, String appSecret, String templateName) {
        try {
            ArrayList parameters = (ArrayList)list;
            WegoSmsSingleSender sender = MobileMessageUtil.create(cloudAppId, appSecret, templateName);
            SmsSingleSenderResult result = sender.sendWithParam("86", mobileTelephoneNumber, templateId, parameters, templateName, "", "");
            MobileMsgMapper mobileMsgMapper = (MobileMsgMapper)SpringUtil.getBean(MobileMsgMapper.class);
            AuthenticationUser authenticationUser = (AuthenticationUser)SpringUtil.getBean(AuthenticationUser.class);
            String appId = authenticationUser == null ? "" : authenticationUser.getAppId();
            MobileMsg mobileMsg = new MobileMsg();
            mobileMsg.setId(GuidGenerator.generate());
            mobileMsg.setAppId(appId);
            mobileMsg.setMobile(mobileTelephoneNumber);
            mobileMsg.setContent(parameters.toString());
            mobileMsg.setSendTime(new Date());
            mobileMsg.setCreateTime(new Date());
            mobileMsg.setTempleId(templateId);
            mobileMsg.setSignId(templateName);
            mobileMsg.setStatus(result.result);
            mobileMsg.setErrMsg(result.errMsg);
            mobileMsgMapper.insert((Object)mobileMsg);
            return new SmsResponse(result.result, result.errMsg, mobileTelephoneNumber, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SendMobileMessageFailException("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25");
        }
    }
}

